/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.utils;

import javax.enterprise.event.Observes;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.events.TableCreationEvent;
import org.gcube.data.analysis.tabulardata.cube.events.TableRemovedEvent;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.utils.TableContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TableEventListener {
    private static final Logger log = LoggerFactory.getLogger(TableEventListener.class);

    public void onCreated(@Observes TableCreationEvent event) {
        TableId tableId = event.getTable().getId();
        String threadGroup = Thread.currentThread().getThreadGroup().getName();
        if (threadGroup.equals("main")) {
            return;
        }
        log.debug("received event creation for table " + tableId.getValue() + " for thread group " + threadGroup);
        TableContainer.add((TableId)tableId);
    }

    public void onRemoved(@Observes TableRemovedEvent event) {
        TableId tableId = event.getTableId();
        String threadGroup = Thread.currentThread().getThreadGroup().getName();
        if (threadGroup.equals("main")) {
            return;
        }
        log.debug("received event deletion for table " + tableId.getValue() + " for thread group " + threadGroup);
        if (TableContainer.get((String)threadGroup) != null && TableContainer.get((String)threadGroup).remove(tableId)) {
            log.debug("table " + tableId.getValue() + " removed from container in group " + threadGroup);
        }
    }
}

