/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.weld;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Iterator;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import org.apache.naming.resources.DirContextURLStreamHandlerFactory;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.data.analysis.tabulardata.weld.ConfigurableStreamHandlerFactory;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.environment.servlet.Listener;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.manager.BeanManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeldResolver<T>
extends InstanceResolver<T> {
    private static final Logger log = LoggerFactory.getLogger(WeldResolver.class);
    private BeanManager mgr;
    private WSWebServiceContext context;
    private WSEndpoint endpoint;
    private static boolean handlerInitialized = false;
    private final Class<T> type;

    public WeldResolver(Class<T> type) {
        this.type = type;
    }

    public T resolve(Packet request) {
        try {
            Iterator it = this.beanManager(request).getBeans((Type)this.type, new Annotation[0]).iterator();
            if (it.hasNext()) {
                Bean endpointBean = (Bean)it.next();
                Context ctx = this.beanManager(request).getContext(endpointBean.getScope());
                return (T)ctx.get((Contextual)endpointBean, this.beanManager(request).createCreationalContext((Contextual)endpointBean));
            }
            throw new Exception("WELD listener is not configured?");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void dispose() {
        log.info("disposing class " + this.endpoint.getImplementationClass().getSimpleName());
        super.dispose();
    }

    public void start(WSWebServiceContext wsc, WSEndpoint endpoint) {
        super.start(wsc, endpoint);
        log.info("starting class " + endpoint.getImplementationClass().getSimpleName());
        if (!handlerInitialized) {
            DirContextURLStreamHandlerFactory.addUserFactory((URLStreamHandlerFactory)new ConfigurableStreamHandlerFactory("smp", (URLStreamHandler)new Handler()));
            handlerInitialized = true;
            log.info("SMP protocol initialized");
        }
        this.context = wsc;
        this.endpoint = endpoint;
    }

    private BeanManager beanManager(Packet request) {
        if (this.mgr == null) {
            this.init(request);
        }
        return this.mgr;
    }

    private void init(Packet request) {
        ServletContext cxt = (ServletContext)request.get((Object)"javax.xml.ws.servlet.context");
        this.mgr = (BeanManagerImpl)cxt.getAttribute(Listener.BEAN_MANAGER_ATTRIBUTE_NAME);
        this.installResourceInjectionService(this.mgr);
    }

    private void installResourceInjectionService(BeanManager mgr) {
        ServiceRegistry registry = ((BeanManagerImpl)mgr).getServices();
        ResourceInjectionServices jsr250InjectionService = (ResourceInjectionServices)registry.get(ResourceInjectionServices.class);
        registry.add(ResourceInjectionServices.class, (Service)new /* Unavailable Anonymous Inner Class!! */);
    }
}

