/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.mapping;

import java.sql.Date;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.GeometryType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDDate;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDInteger;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDNumeric;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDText;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.mapping.SQLModelMapper;

@Singleton
public class PostgreSQLModelMapper
implements SQLModelMapper {
    @Override
    public String translateModelValueToSQL(TDBoolean value) {
        return value.getValue().toString();
    }

    @Override
    public String translateModelValueToSQL(TDText value) {
        return "'" + value.getValue() + "'";
    }

    @Override
    public String translateModelValueToSQL(TDInteger value) {
        return value.getValue().toString();
    }

    @Override
    public String translateModelValueToSQL(TDNumeric value) {
        return value.getValue().toString();
    }

    @Override
    public String translateModelValueToSQL(TDDate value) {
        Date sqlDate = new Date(value.getValue().getTime());
        return "'" + sqlDate.toString() + "'";
    }

    @Override
    public String translateModelValueToSQL(TDTypeValue value) {
        if (value instanceof TDBoolean) {
            return this.translateModelValueToSQL((TDBoolean)value);
        }
        if (value instanceof TDText) {
            return this.translateModelValueToSQL((TDText)value);
        }
        if (value instanceof TDInteger) {
            return this.translateModelValueToSQL((TDInteger)value);
        }
        if (value instanceof TDNumeric) {
            return this.translateModelValueToSQL((TDNumeric)value);
        }
        if (value instanceof TDDate) {
            return this.translateModelValueToSQL((TDDate)value);
        }
        throw new RuntimeException(String.format("Do not know how to translate value '%s' into SQL.", value));
    }

    @Override
    public String translateDataTypeToSQL(DataType type) {
        if (type.getClass().equals(BooleanType.class)) {
            return "boolean";
        }
        if (type.getClass().equals(DateType.class)) {
            return "date";
        }
        if (type.getClass().equals(GeometryType.class)) {
            GeometryType geometryType = (GeometryType)type;
            return String.format("geometry(%1$s,%2$s)", this.generateGeometryTypeString(geometryType), geometryType.getSrid());
        }
        if (type.getClass().equals(IntegerType.class)) {
            return "integer";
        }
        if (type.getClass().equals(NumericType.class)) {
            NumericType numericType = (NumericType)type;
            if (numericType.getPrecision() != null && numericType.getScale() != null) {
                return String.format("numeric(%1$s,%2$s)", numericType.getPrecision(), numericType.getScale());
            }
            if (numericType.getPrecision() != null) {
                return String.format("numeric(%1$s)", numericType.getPrecision());
            }
            return "numeric";
        }
        if (type.getClass().equals(TextType.class)) {
            TextType textType = (TextType)type;
            return String.format("varchar(%1$s)", textType.getLenght());
        }
        throw new RuntimeException("Don't know how to translate type " + type + " into a SQL type.");
    }

    private String generateGeometryTypeString(GeometryType geometryType) {
        return geometryType.getGeometryType().toString();
    }
}

