package org.gcube.data.analysis.tabulardata.model.column.factories;

import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;

public class AttributeColumnFactory extends BaseColumnFactory{
	
	static private ColumnType TYPE = new AttributeColumnType();
	
	public static Column create(LocalizedText label, DataType dataType){
		return create(TYPE,label,dataType);
	}
	
	public static Column create(){
		return create(TYPE,new TextType());
	}
	
	public static Column create(DataType type){
		return create(TYPE,type);
	}
	
}
