package org.gcube.data.analysis.tabulardata.model.column.factories;

import java.util.ArrayList;
import java.util.List;

import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;

public class CodeDescriptionColumnFactory extends BaseColumnFactory{

	public static Column create(String dataLocale){
		Column column = create(new CodeDescriptionColumnType(), new TextType());
		column.setMetadata(new DataLocaleMetadata(dataLocale));
		List<LocalizedText> texts = new ArrayList<LocalizedText>();
		texts.add(new ImmutableLocalizedText("description_"+dataLocale,"en"));
		NamesMetadata labelsMetadata = new NamesMetadata(texts);
		column.setMetadata(labelsMetadata);
		return column;
	} 
	
}
