/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.column.factories;

import java.util.List;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.factories.BaseColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.DescriptionsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;

public class ValidationColumnFactory
extends BaseColumnFactory {
    public static Column create(LocalizedText name, DataValidationMetadata validationMetadata) {
        Column column = ValidationColumnFactory.create((ColumnType)new ValidationColumnType(), name, (DataType)new BooleanType());
        column.setMetadata((ColumnMetadata)validationMetadata);
        return column;
    }

    public static Column create(List<LocalizedText> names, List<LocalizedText> descriptions, DataValidationMetadata validationMetadata) {
        Column column = ValidationColumnFactory.create((ColumnType)new ValidationColumnType(), (DataType)new BooleanType());
        if (names.size() < 1) {
            throw new IllegalArgumentException("Must provide at least one label");
        }
        column.setMetadata((ColumnMetadata)new NamesMetadata(names));
        if (descriptions.size() > 0) {
            column.setMetadata((ColumnMetadata)new DescriptionsMetadata(names));
        }
        column.setMetadata((ColumnMetadata)validationMetadata);
        return column;
    }
}

