/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.column.factories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.factories.BaseColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.DescriptionsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;

public class ValidationColumnFactory
extends BaseColumnFactory<ValidationColumnType> {
    private static final ArrayList<LocalizedText> DEFAULT_LABELS = new ArrayList();

    @Override
    protected Collection<LocalizedText> getDefaultLabels() {
        return DEFAULT_LABELS;
    }

    public Column create(List<LocalizedText> names, List<LocalizedText> descriptions, DataValidationMetadata validationMetadata) {
        if (names.size() < 1) {
            throw new IllegalArgumentException("Must provide at least one label");
        }
        Column column = this.create(this.getManagedColumnType().getDefaultDataType(), names);
        if (descriptions.size() > 0) {
            column.setMetadata((ColumnMetadata)new DescriptionsMetadata(names));
        }
        column.setMetadata((ColumnMetadata)validationMetadata);
        return column;
    }

    @Override
    public ValidationColumnType getManagedColumnType() {
        return new ValidationColumnType();
    }

    static {
        DEFAULT_LABELS.add((LocalizedText)new ImmutableLocalizedText("Validation"));
    }
}

