/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.column.factories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.factories.AnnotationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.AttributeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.CodeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.CodeDescriptionColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.CodeNameColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.ColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.DimensionColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.IdColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.MeasureColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.TimeDimensionColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.ValidationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;

public abstract class BaseColumnFactory<T extends ColumnType>
implements ColumnFactory<T> {
    protected DataLocaleMetadata DEFAULT_LOCALE = new DataLocaleMetadata(Locale.getDefault().toString());

    public abstract T getManagedColumnType();

    protected abstract Collection<LocalizedText> getDefaultLabels();

    @Override
    public Column createDefault() {
        return this.create((ColumnType)this.getManagedColumnType(), this.getManagedColumnType().getDefaultDataType(), this.DEFAULT_LOCALE, this.getDefaultLabels());
    }

    @Override
    public Column create(DataType dataType) {
        return this.create((ColumnType)this.getManagedColumnType(), dataType, this.DEFAULT_LOCALE, this.getDefaultLabels());
    }

    @Override
    public Column create(DataType dataType, Collection<LocalizedText> labels) {
        return this.create((ColumnType)this.getManagedColumnType(), dataType, this.DEFAULT_LOCALE, labels);
    }

    @Override
    public Column create(DataType dataType, Collection<LocalizedText> labels, String dataLocale) {
        return this.create((ColumnType)this.getManagedColumnType(), dataType, new DataLocaleMetadata(dataLocale), labels);
    }

    @Override
    public Column create(DataType dataType, Collection<LocalizedText> labels, DataLocaleMetadata dataLocale) {
        return this.create((ColumnType)this.getManagedColumnType(), dataType, dataLocale, labels);
    }

    @Override
    public Column create(LocalizedText label) {
        return this.create(label, this.DEFAULT_LOCALE);
    }

    @Override
    public Column create(LocalizedText label, DataLocaleMetadata dataLocale) {
        List<LocalizedText> labels = Collections.singletonList(label);
        return this.create(this.getManagedColumnType().getDefaultDataType(), labels, dataLocale);
    }

    @Override
    public Column create(LocalizedText label, DataType dataType) {
        List<LocalizedText> labels = Collections.singletonList(label);
        return this.create(dataType, labels, this.DEFAULT_LOCALE);
    }

    protected Column create(ColumnType columnType, DataType dataType, DataLocaleMetadata dataLocale, Collection<LocalizedText> labels) {
        if (columnType == null) {
            throw new IllegalArgumentException("Column type cannot be null");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("Column dataType cannot be null");
        }
        if (!columnType.isDataTypeAllowed(dataType)) {
            throw new IllegalArgumentException(String.format("Invalid DataType %s for column type %s, Allowed Types are %s ", dataType, columnType, columnType.getAllowedDataTypes()));
        }
        Column result = new Column(BaseColumnFactory.generateColumnId(), dataType, columnType);
        NamesMetadata labelsMetadata = null;
        try {
            labelsMetadata = (NamesMetadata)result.getMetadata(NamesMetadata.class);
        }
        catch (NoSuchMetadataException e) {
            ArrayList<LocalizedText> texts = new ArrayList<LocalizedText>();
            for (LocalizedText label : labels) {
                texts.add(label);
            }
            labelsMetadata = new NamesMetadata(texts);
        }
        result.setMetadata((ColumnMetadata)labelsMetadata);
        if (dataLocale != null) {
            result.setMetadata((ColumnMetadata)dataLocale);
        }
        return result;
    }

    private static ColumnLocalId generateColumnId() {
        return new ColumnLocalId(UUID.randomUUID().toString());
    }

    protected static Column create(ColumnType columnType, DataType dataType) {
        return new Column(BaseColumnFactory.generateColumnId(), dataType, columnType);
    }

    public static final ColumnFactory<?> getFactory(ColumnType columnType) {
        if (columnType instanceof AnnotationColumnType) {
            return new AnnotationColumnFactory();
        }
        if (columnType instanceof AttributeColumnType) {
            return new AttributeColumnFactory();
        }
        if (columnType instanceof CodeColumnType) {
            return new CodeColumnFactory();
        }
        if (columnType instanceof CodeDescriptionColumnType) {
            return new CodeDescriptionColumnFactory();
        }
        if (columnType instanceof CodeNameColumnType) {
            return new CodeNameColumnFactory();
        }
        if (columnType instanceof DimensionColumnType) {
            return new DimensionColumnFactory();
        }
        if (columnType instanceof IdColumnType) {
            return new IdColumnFactory();
        }
        if (columnType instanceof MeasureColumnType) {
            return new MeasureColumnFactory();
        }
        if (columnType instanceof TimeDimensionColumnType) {
            return new TimeDimensionColumnFactory();
        }
        if (columnType instanceof ValidationColumnType) {
            return new ValidationColumnFactory();
        }
        throw new IllegalArgumentException(String.format("No Factory defined for column type %s", columnType));
    }
}

