package org.gcube.data.analysis.tabulardata.model.datatype;

import org.gcube.data.analysis.tabulardata.model.datatype.geometry.GeometryType;

public class Geometry implements DataType {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 522898962047621730L;

	private int srid = -1;
	
	private GeometryType type;
	
	private int dimensions;
	
	public Geometry(int srid, int dimensions) {
		this.srid = srid;
		this.type = GeometryType.GEOMETRY;
		this.dimensions = dimensions;
	}
	public Geometry(int dimensions) {
		this.type = GeometryType.GEOMETRY;
		this.dimensions = dimensions;
	}
	
	public Geometry(int srid, GeometryType type, int dimensions) {
		super();
		this.srid = srid;
		if (type == null )throw new IllegalArgumentException("type cannot be null.");
		this.type = type;
		this.dimensions = dimensions;
	}
	
	public Geometry(GeometryType type, int dimensions) {
		super();
		this.type = type;
		this.dimensions = dimensions;
	}

	public DataTypeEnum getDataType() {
		return DataTypeEnum.GEOMETRY;
	}

	public int getSrid() {
		return srid;
	}

	public GeometryType getGeometryType() {
		return type;
	}

	public int getDimensions() {
		return dimensions;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + dimensions;
		result = prime * result + srid;
		result = prime * result + ((type == null) ? 0 : type.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Geometry other = (Geometry) obj;
		if (dimensions != other.dimensions)
			return false;
		if (srid != other.srid)
			return false;
		if (type != other.type)
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("Geometry(");
		builder.append(srid);
		builder.append(",");
		builder.append(type);
		builder.append(",");
		builder.append(dimensions);
		builder.append(")");
		return builder.toString();
	}
	
}
