package org.gcube.data.analysis.tabulardata.model.reference;


public class ColumnReferenceImpl implements ColumnReference {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -4569485132753812680L;

	TableReference tableReference;
	
	String columnName;
	
	public ColumnReferenceImpl(TableReference tableReference, String columnName) {
		super();
		this.tableReference = tableReference;
		this.columnName = columnName;
	}
	
	public ColumnReferenceImpl(long tableId, String columnName){
		super();
		this.tableReference=new TableReferenceImpl(tableId);
		this.columnName = columnName;
	}

	/* (non-Javadoc)
	 * @see org.gcube.data.td.cube.model.table.ColumnReference#getId()
	 */
	@Override
	public long getTableId() {
		return tableReference.getTableId();
	}

	/* (non-Javadoc)
	 * @see org.gcube.data.td.cube.model.table.ColumnReference#getColumnName()
	 */
	@Override
	public String getColumnName() {
		return columnName;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ColumnReferenceImpl [tableReference=");
		builder.append(tableReference);
		builder.append(", columnName=");
		builder.append(columnName);
		builder.append("]");
		return builder.toString();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((columnName == null) ? 0 : columnName.hashCode());
		result = prime * result
				+ ((tableReference == null) ? 0 : tableReference.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ColumnReferenceImpl other = (ColumnReferenceImpl) obj;
		if (columnName == null) {
			if (other.columnName != null)
				return false;
		} else if (!columnName.equals(other.columnName))
			return false;
		if (tableReference == null) {
			if (other.tableReference != null)
				return false;
		} else if (!tableReference.equals(other.tableReference))
			return false;
		return true;
	}
	
	
	
	
	
}
