/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.datatype;

import com.google.common.base.Optional;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataTypeEnum;

public class Numeric
implements DataType {
    private static final long serialVersionUID = -1778127136791503220L;
    Optional<Integer> precision;
    Optional<Integer> scale;

    public Numeric() {
        this.scale = Optional.absent();
        this.precision = Optional.absent();
    }

    public Numeric(int precision) {
        if (precision <= 0) {
            throw new IllegalArgumentException("Precision must be positive");
        }
        this.precision = Optional.of((Object)precision);
    }

    public Numeric(int precision, int scale) {
        if (precision <= 0) {
            throw new IllegalArgumentException("Precision must be positive.");
        }
        if (scale < 0 || scale > precision) {
            throw new IllegalArgumentException("Scale must be 0 or less than precision.");
        }
        this.precision = Optional.of((Object)precision);
        this.scale = Optional.of((Object)scale);
    }

    @Override
    public DataTypeEnum getDataType() {
        return DataTypeEnum.NUMERIC;
    }

    public boolean hasPrecision() {
        return this.precision.isPresent();
    }

    public int getPrecision() {
        return (Integer)this.precision.get();
    }

    public boolean hasScale() {
        return this.scale.isPresent();
    }

    public int getScale() {
        return (Integer)this.scale.get();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.precision == null ? 0 : this.precision.hashCode());
        result = 31 * result + (this.scale == null ? 0 : this.scale.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Numeric other = (Numeric)obj;
        if (this.precision == null ? other.precision != null : !this.precision.equals(other.precision)) {
            return false;
        }
        return !(this.scale == null ? other.scale != null : !this.scale.equals(other.scale));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Numeric(");
        builder.append(this.precision);
        builder.append(",");
        builder.append(this.scale);
        builder.append(")");
        return builder.toString();
    }
}

