package org.gcube.data.analysis.tabulardata.expression.composite.arithmetic;

import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.Operator;
import org.gcube.data.analysis.tabulardata.expression.composite.BinaryExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
@XmlRootElement
public class Addition extends BinaryExpression {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5056770141256757663L;

	@SuppressWarnings("unused")
	private Addition() {}

	public Addition(Expression leftArgument, Expression rightArgument) {
		super(leftArgument, rightArgument);	
	}

	@Override
	public Operator getOperator() {		
		return Operator.ADDITION;
	}
	
	@Override
	public DataType getReturnedDataType() throws MalformedExpressionException {
		DataType left=getLeftArgument().getReturnedDataType();
		DataType right=getRightArgument().getReturnedDataType();
		if(left==right) return left;
		if(left instanceof TextType||right instanceof TextType) return new TextType();
		if(left instanceof NumericType||right instanceof NumericType) return new NumericType();
		throw new MalformedExpressionException("Left argument "+left+" and right argument "+right+" are not compatible for "+getOperator());
	}
}
