/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.expression.composite.text;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.NotEvaluableDataTypeException;
import org.gcube.data.analysis.tabulardata.expression.Operator;
import org.gcube.data.analysis.tabulardata.expression.composite.CompositeExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SubstringByIndex
extends CompositeExpression {
    private static final long serialVersionUID = 5567106578891064168L;
    private Expression sourceString;
    private Expression fromIndex;
    private Expression toIndex;

    private SubstringByIndex() {
    }

    public SubstringByIndex(Expression sourceString, Expression fromIndex, Expression toIndex) {
        this.sourceString = sourceString;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    @Override
    public Operator getOperator() {
        return Operator.SUBSTRING_BY_INDEX;
    }

    @Override
    public void validate() throws MalformedExpressionException {
        if (this.sourceString == null) {
            throw new MalformedExpressionException("Source string cannot be null. " + this);
        }
        if (this.fromIndex == null) {
            throw new MalformedExpressionException("From Index cannot be null. " + this);
        }
        if (this.toIndex == null) {
            throw new MalformedExpressionException("Source string cannot be null. " + this);
        }
        this.sourceString.validate();
        this.fromIndex.validate();
        this.toIndex.validate();
        try {
            DataType sourceType = this.sourceString.getReturnedDataType();
            if (!(sourceType instanceof TextType)) {
                throw new MalformedExpressionException("Source string expression must return string type. Returned Type is " + sourceType.getName() + "." + this);
            }
        }
        catch (NotEvaluableDataTypeException e) {
            // empty catch block
        }
        try {
            DataType fromType = this.fromIndex.getReturnedDataType();
            if (!(fromType instanceof IntegerType)) {
                throw new MalformedExpressionException("From index expression must return integer type. Returned Type is " + fromType.getName() + "." + this);
            }
        }
        catch (NotEvaluableDataTypeException e) {
            // empty catch block
        }
        try {
            DataType toType = this.toIndex.getReturnedDataType();
            if (!(toType instanceof IntegerType)) {
                throw new MalformedExpressionException("To index expression must return integer type. Returned Type is " + toType.getName() + "." + this);
            }
        }
        catch (NotEvaluableDataTypeException notEvaluableDataTypeException) {
            // empty catch block
        }
    }

    @Override
    public DataType getReturnedDataType() throws NotEvaluableDataTypeException {
        return new TextType();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SubstringByIndex [sourceString=");
        builder.append(this.sourceString);
        builder.append(", fromIndex=");
        builder.append(this.fromIndex);
        builder.append(", toIndex=");
        builder.append(this.toIndex);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fromIndex == null ? 0 : this.fromIndex.hashCode());
        result = 31 * result + (this.sourceString == null ? 0 : this.sourceString.hashCode());
        result = 31 * result + (this.toIndex == null ? 0 : this.toIndex.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubstringByIndex other = (SubstringByIndex)obj;
        if (this.fromIndex == null ? other.fromIndex != null : !this.fromIndex.equals(other.fromIndex)) {
            return false;
        }
        if (this.sourceString == null ? other.sourceString != null : !this.sourceString.equals(other.sourceString)) {
            return false;
        }
        return !(this.toIndex == null ? other.toIndex != null : !this.toIndex.equals(other.toIndex));
    }

    public Expression getSourceString() {
        return this.sourceString;
    }

    public void setSourceString(Expression sourceString) {
        this.sourceString = sourceString;
    }

    public Expression getFromIndex() {
        return this.fromIndex;
    }

    public void setFromIndex(Expression fromIndex) {
        this.fromIndex = fromIndex;
    }

    public Expression getToIndex() {
        return this.toIndex;
    }

    public void setToIndex(Expression toIndex) {
        this.toIndex = toIndex;
    }
}

