/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.metadata.column;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;

@XmlRootElement(name="DataValidationMetadata")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DataValidationMetadata
implements ColumnMetadata {
    private static final long serialVersionUID = 5346249544710409540L;
    @XmlElement(type=ImmutableLocalizedText.class)
    private LocalizedText description;
    private int invalidRowsCount;

    private DataValidationMetadata() {
    }

    public DataValidationMetadata(LocalizedText description, int invalidCount) {
        this.description = description;
        this.invalidRowsCount = invalidCount;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    public boolean isValid() {
        return this.invalidRowsCount == 0;
    }

    public int getInvalidRowsCount() {
        return this.invalidRowsCount;
    }

    @Override
    public boolean isInheritable() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + this.invalidRowsCount;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataValidationMetadata other = (DataValidationMetadata)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return this.invalidRowsCount == other.invalidRowsCount;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DataValidationMetadata [description=");
        builder.append(this.description);
        builder.append(", invalidRowsCount=");
        builder.append(this.invalidRowsCount);
        builder.append("]");
        return builder.toString();
    }
}

