/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.expression.composite;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.NotEvaluableDataTypeException;
import org.gcube.data.analysis.tabulardata.expression.composite.CompositeExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class MultipleArgumentsExpression
extends CompositeExpression {
    private static final long serialVersionUID = 3064772540730484570L;
    private static final List<Class<? extends DataType>> DEFAULT_ACCEPTED_TYPES = new ArrayList<Class<? extends DataType>>();
    private List<Expression> arguments = null;

    protected MultipleArgumentsExpression() {
    }

    protected MultipleArgumentsExpression(List<Expression> arguments) {
        this.arguments = arguments;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<Expression> arguments) {
        this.arguments = arguments;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arguments == null ? 0 : this.arguments.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultipleArgumentsExpression other = (MultipleArgumentsExpression)obj;
        return !(this.arguments == null ? other.arguments != null : !this.arguments.equals(other.arguments));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MultipleArgumentsExpression [");
        builder.append((Object)this.getOperator());
        builder.append(",");
        builder.append(this.arguments);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void validate() throws MalformedExpressionException {
        if (this.arguments == null) {
            throw new MalformedExpressionException("Null arguments list in expression " + this);
        }
        for (Expression expr : this.arguments) {
            if (expr != null) continue;
            throw new MalformedExpressionException("Null argument in expression " + this);
        }
        for (Expression expr : this.arguments) {
            expr.validate();
        }
        for (Expression expr : this.arguments) {
            try {
                DataType type = expr.getReturnedDataType();
                if (this.allowedDataTypes().contains(type.getClass())) continue;
                throw new MalformedExpressionException(String.format("Unexpected argument data type %s, allowed types are %s ", type, this.allowedDataTypes()));
            }
            catch (NotEvaluableDataTypeException notEvaluableDataTypeException) {
            }
        }
    }

    public List<Class<? extends DataType>> allowedDataTypes() {
        return DEFAULT_ACCEPTED_TYPES;
    }

    static {
        DEFAULT_ACCEPTED_TYPES.add(TextType.class);
        DEFAULT_ACCEPTED_TYPES.add(BooleanType.class);
        DEFAULT_ACCEPTED_TYPES.add(DateType.class);
        DEFAULT_ACCEPTED_TYPES.add(IntegerType.class);
        DEFAULT_ACCEPTED_TYPES.add(NumericType.class);
    }
}

