/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.datatype.value;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TDNumeric
extends TDTypeValue {
    private static final long serialVersionUID = -7482958149525781700L;
    Float value;
    Double doubleValue;

    private TDNumeric() {
    }

    public TDNumeric(Double value) {
        this.doubleValue = value;
    }

    public TDNumeric(Float value) {
        this.value = value;
    }

    public Double getValue() {
        if (this.doubleValue == null) {
            return new Double(this.value.floatValue());
        }
        return this.doubleValue;
    }

    public String toString() {
        return this.getValue().toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.doubleValue == null ? 0 : this.doubleValue.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TDNumeric other = (TDNumeric)obj;
        if (this.doubleValue == null ? other.doubleValue != null : !this.doubleValue.equals(other.doubleValue)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public void validate() throws MalformedExpressionException {
        if (this.getValue() == null) {
            throw new MalformedExpressionException("Numeric constant value cannot be null");
        }
    }

    @Override
    public int compareTo(TDTypeValue o) {
        return this.getValue().compareTo(((TDNumeric)o).getValue());
    }

    @Override
    public DataType getReturnedDataType() {
        return new NumericType();
    }
}

