/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.metadata.table;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class VersionMetadata
implements TableMetadata {
    private static final long serialVersionUID = -7149497935228705769L;
    private String version = null;
    public static String VERSION_REGEX = "^(([1-9][0-9]*[1-9])|[0-9])\\.(([1-9][0-9]*[1-9])|[0-9])$";

    private VersionMetadata() {
    }

    public VersionMetadata(String version) {
        this.setVersion(version);
    }

    public String getVersion() {
        return this.version;
    }

    private void setVersion(String version) {
        if (version == null || !version.matches(VERSION_REGEX)) {
            throw new IllegalArgumentException(String.format("Version '%s' does not match regex '%s'", version, VERSION_REGEX));
        }
        this.version = version;
    }

    @Override
    public boolean isInheritable() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionMetadata other = (VersionMetadata)obj;
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VersionMetadata [version=");
        builder.append(this.version);
        builder.append("]");
        return builder.toString();
    }
}

