/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.resources;

import java.net.URL;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.resources.Resource;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SDMXResource
extends Resource {
    private static final long serialVersionUID = -8695994802487301542L;
    private String version;
    private String agency;
    private String primaryMeasure;
    private String name;
    private URL url;
    private TYPE type;

    public SDMXResource() {
    }

    public SDMXResource(URL url, String name, String version, String agency, String primaryMeasure, TYPE type) {
        this.url = url;
        this.name = name;
        this.version = version;
        this.agency = agency;
        this.primaryMeasure = primaryMeasure;
        this.type = type;
    }

    public SDMXResource(URL url, String name, String version, String agency, TYPE type) {
        this(url, name, version, agency, null, type);
    }

    @Override
    public String getStringValue() {
        return String.format("%s/%s/%s/%s/ - type: %s  primary measure: %s ", new Object[]{this.getURL(), this.agency, this.name, this.version, this.type, this.primaryMeasure});
    }

    public String getVersion() {
        return this.version;
    }

    public String getAgency() {
        return this.agency;
    }

    public String getPrimaryMeasure() {
        return this.primaryMeasure;
    }

    public String getName() {
        return this.name;
    }

    public TYPE getType() {
        return this.type;
    }

    @Override
    public Class<? extends Resource> getResourceType() {
        return this.getClass();
    }

    public URL getURL() {
        return this.url;
    }

    public boolean equals(Object sdmxResource) {
        if (sdmxResource instanceof SDMXResource) {
            SDMXResource sdmx = (SDMXResource)sdmxResource;
            return this.checkEqual(this.getURL(), sdmx.getURL()) && this.checkEqual(this.name, sdmx.getName()) && this.checkEqual(this.agency, sdmx.getAgency()) && this.checkEqual(this.primaryMeasure, sdmx.getPrimaryMeasure()) && this.checkEqual((Object)this.type, (Object)sdmx.getType()) && this.checkEqual(this.version, sdmx.getVersion());
        }
        return super.equals(sdmxResource);
    }

    private boolean checkEqual(Object object1, Object object2) {
        return object1 == null && object2 == null || object1 != null && object1.equals(object2);
    }

    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder("SDMX Resource [");
        toStringBuilder.append((Object)this.type).append(", ").append(this.name).append(", ").append(this.version).append(", agency ").append(this.agency);
        if (this.primaryMeasure != null) {
            toStringBuilder.append(", primary measure ").append(this.primaryMeasure);
        }
        toStringBuilder.append(", url ").append(this.url).append("]");
        return toStringBuilder.toString();
    }

    public static enum TYPE {
        DATA_STRUCTURE("DataStructure"),
        CODE_LIST("CodeList");

        private String type;

        private TYPE(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

