package org.gcube.data.analysis.tabulardata.model.resources;

import java.net.URL;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class SDMXResource extends WebResource {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8695994802487301542L;

	public enum TYPE {
		DATA_STRUCTURE ("DataStructure"),
		CODE_LIST ("CodeList");
		
		private String type;
		
		TYPE (String type)
		{
			this.type = type;
		}
		
		@Override
		public String toString ()
		{
			return this.type;
		}
	}
	

	private String 	version,
					agency,
					primaryMeasure,
					name;
	
	private TYPE type;

	public  SDMXResource ()
	{
		super ();
	}

	
	public SDMXResource (URL url,String name, String version, String agency, String primaryMeasure, TYPE type )
	{
		super (url);
		this.name = name;
		this.version = version;
		this.agency = agency;
		this.primaryMeasure = primaryMeasure;
		this.type = type;
	}

	public SDMXResource (URL url,String name, String version, String agency, TYPE type )
	{
		this (url,name, version, agency,null, type);
	}

	@Override
	public String getStringValue() 
	{	String.format("%s/%s/%s/%s/ - type: %s  primary measure: %s ", getURL(), this.agency, this.name, this.version,this.type,this.primaryMeasure);
		return super.getStringValue();
	}


	public String getVersion() {
		return version;
	}

	public String getAgency() {
		return agency;
	}

	public String getPrimaryMeasure() {
		return primaryMeasure;
	}

	public String getName() {
		return name;
	}

	public TYPE getType() {
		return type;
	}

	@Override
	public Class<? extends Resource> getResourceType() {
		return this.getClass();
	}
	

	@Override
	public boolean equals(Object sdmxResource) 
	{
		if (sdmxResource instanceof SDMXResource)
		{
			SDMXResource sdmx = (SDMXResource) sdmxResource;
			
			return (checkEqual(getURL(), sdmx.getURL()) &&
					checkEqual(this.name, sdmx.getName()) &&
					checkEqual(this.agency, sdmx.getAgency()) &&
					checkEqual(this.primaryMeasure, sdmx.getPrimaryMeasure()) &&
					checkEqual(this.type, sdmx.getType()) &&
					checkEqual(this.version, sdmx.getVersion()));
		}
		else return super.equals(sdmxResource);
		

		
	}
	
	private boolean checkEqual (Object object1, Object object2)
	{
		return ((object1 == null && object2 == null) || (object1!= null && (object1.equals(object2))));
	}
	
	@Override
	public String toString() {
		StringBuilder toStringBuilder = new StringBuilder ("SDMX Resource [");
		toStringBuilder.append(this.type).append(", ").append(this.name).append(", ").append(this.version).append(", agency ").append(this.agency);
		
		if (primaryMeasure != null) toStringBuilder.append(", primary measure ").append(primaryMeasure);
		
		toStringBuilder.append(", url ").append(super.getStringValue()).append("]");
		return toStringBuilder.toString();
	}

}
