package org.gcube.data.analysis.tabulardata.query.parameters;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.And;
import org.gcube.data.analysis.tabulardata.expression.composite.Or;
import org.gcube.data.analysis.tabulardata.expression.leaf.IsNull;
import org.gcube.data.analysis.tabulardata.expression.leaf.ValueIsIn;
import org.gcube.data.analysis.tabulardata.expression.leaf.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.leaf.comparable.GreaterThan;
import org.gcube.data.analysis.tabulardata.expression.leaf.comparable.LessThan;
import org.gcube.data.analysis.tabulardata.expression.leaf.comparable.NotEquals;
import org.gcube.data.analysis.tabulardata.expression.leaf.text.TextContains;
import org.gcube.data.analysis.tabulardata.expression.leaf.text.TextEquals;
import org.gcube.data.analysis.tabulardata.expression.leaf.text.TextMatchSQLRegexp;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)

public class QueryFilter {

//	@XmlElementRefs({ 
//		@XmlElementRef(type = And.class), 
//		@XmlElementRef(type = Or.class),
//		@XmlElementRef(type = IsNull.class),
//		@XmlElementRef(type = ValueIsIn.class),
//		@XmlElementRef(type = Equals.class),
//		@XmlElementRef(type = GreaterThan.class),
//		@XmlElementRef(type = LessThan.class),
//		@XmlElementRef(type = NotEquals.class),
//		@XmlElementRef(type = TextContains.class),
//		@XmlElementRef(type = TextEquals.class),
//		@XmlElementRef(type = TextMatchSQLRegexp.class),
//	})
	private Expression expression;

	@SuppressWarnings("unused")
	private QueryFilter() {
	}

	public QueryFilter(Expression expression) {
		super();
		this.expression = expression;
	}

	public Expression getFilterExpression() {
		return expression;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((expression == null) ? 0 : expression.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		QueryFilter other = (QueryFilter) obj;
		if (expression == null) {
			if (other.expression != null)
				return false;
		} else if (!expression.equals(other.expression))
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("QueryFilter [expression=");
		builder.append(expression);
		builder.append("]");
		return builder.toString();
	}

}
