/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLResultSetIterator
implements Iterator<String[]> {
    Logger log = LoggerFactory.getLogger(SQLResultSetIterator.class);
    ResultSet rs;

    public SQLResultSetIterator(ResultSet rs) {
        this.rs = rs;
    }

    @Override
    public boolean hasNext() {
        try {
            return !this.rs.isLast();
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to read query result from DB. Check server logs.");
        }
    }

    @Override
    public String[] next() {
        int numCols;
        block4: {
            boolean valid = this.rs.next();
            numCols = this.rs.getMetaData().getColumnCount();
            if (valid) break block4;
            return null;
        }
        try {
            String[] result = new String[numCols];
            int i = 0;
            while (i < numCols) {
                result[i] = this.rs.getString(i + 1);
                ++i;
            }
            return result;
        }
        catch (SQLException e) {
            this.log.error("Unable to read row", (Throwable)e);
            throw new RuntimeException("Unable to read result row. Check server error.");
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove operations is unsupported.");
    }
}

