/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.query;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.gcube.common.database.endpoint.DatabaseEndpoint;
import org.gcube.common.database.endpoint.DatabaseProperty;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.levels.Level;
import org.gcube.data.analysis.tabulardata.model.metadata.levels.Levels;
import org.gcube.data.analysis.tabulardata.model.relationship.TableRelationship;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.query.Order;
import org.gcube.data.analysis.tabulardata.query.SQLResultSetIterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Default
public class TabularQuery {
    Logger log = LoggerFactory.getLogger(TabularQuery.class);
    CubeManager cm;

    @Inject
    public TabularQuery(CubeManager cm) {
        this.cm = cm;
    }

    public int getSize(long tableId) {
        String tableName;
        try {
            tableName = this.cm.getTable(tableId).getName();
        }
        catch (NoSuchTableException e) {
            this.log.error(String.format("Unable to retrieve table metadata for table with id %s", tableId), (Throwable)e);
            throw new RuntimeException("Unable to retrieve metadata for the table. Check server logs");
        }
        String sql = String.format("SELECT COUNT(*) FROM $1%s;", tableName);
        ResultSet rs = this.executeQuery(sql);
        try {
            rs.next();
            return rs.getInt(1);
        }
        catch (SQLException e) {
            this.log.error(String.format("An error occurred while querying the database.", tableId), (Throwable)e);
            throw new RuntimeException("An error occurred while querying the database. Check server logs");
        }
    }

    public Iterator<String[]> query(long tableId, int offset, int pagesize, String orderingColumnName, Order order) {
        Table t = null;
        try {
            t = this.cm.getTable(tableId);
        }
        catch (NoSuchTableException e) {
            this.log.error("Error occurred while querying table", (Throwable)e);
            throw new RuntimeException(String.format("Unable to retrieve metadata for the given table id '%s' . Check server logs.", tableId));
        }
        try {
            t.getColumnByName(orderingColumnName);
        }
        catch (Exception e) {
            this.log.error(String.format("Provided ordering column name '%s' is not valid within table %s.", orderingColumnName, t));
            throw new IllegalArgumentException("Given ordering column with name " + orderingColumnName + " does not exists within the table with id " + tableId);
        }
        String columnNames = "";
        List columns = t.getColumns();
        int i = 1;
        for (Column c : columns) {
            columnNames = String.valueOf(columnNames) + c.getName();
            if (i++ >= columns.size()) continue;
            columnNames = String.valueOf(columnNames) + ",";
        }
        String orderString = null;
        orderString = order == Order.ASCENDING ? "ASC" : "DESC";
        String sql = String.format("SELECT %1$s FROM %2$s ORDER BY %3$s %4$s LIMIT %5$s OFFSET %6$s;", columnNames, t.getName(), orderingColumnName, orderString, pagesize, offset);
        return new SQLResultSetIterator(this.executeQuery(sql));
    }

    public Iterator<String[]> query(long tableId, int offset, int pagesize) {
        Table t = null;
        try {
            t = this.cm.getTable(tableId);
        }
        catch (NoSuchTableException e) {
            this.log.error("Error occurred while querying table", (Throwable)e);
            throw new RuntimeException(String.format("Unable to retrieve metadata for the given table id '%s'. Check server logs.", tableId));
        }
        String columnNames = "";
        List columns = t.getColumns();
        int i = 1;
        for (Column c : columns) {
            columnNames = String.valueOf(columnNames) + c.getName();
            if (i++ >= columns.size()) continue;
            columnNames = String.valueOf(columnNames) + ",";
        }
        String sql = String.format("SELECT %s FROM %s LIMIT %s OFFSET %s;", columnNames, t.getName(), pagesize, offset);
        this.log.debug("Executing sql statement: " + sql);
        return new SQLResultSetIterator(this.executeQuery(sql));
    }

    public String queryAsJSON(long tableId, int offset, int pagesize) {
        Iterator<String[]> iterator = this.query(tableId, offset, pagesize);
        Table t = this.getTable(tableId);
        return this.generateJSON(t.getColumns(), iterator);
    }

    public String queryAsJSON(long tableId, int offset, int pagesize, String orderingColumnName, Order order) {
        Iterator<String[]> iterator = this.query(tableId, offset, pagesize);
        Table t = this.getTable(tableId);
        return this.generateJSON(t.getColumns(), iterator);
    }

    public Table generateDatasetView(long tableId) {
        Table dataset = null;
        try {
            dataset = this.cm.getTable(tableId);
        }
        catch (NoSuchTableException e) {
            this.log.error("Cannot find a table with the id: " + tableId + ".");
            throw new IllegalArgumentException("A table with the given id does not exists.", e);
        }
        if (dataset.getTableType() != TableType.DATASET) {
            throw new RuntimeException("The table with the given id is not a dataset.");
        }
        TableCreator ttc = this.cm.createTable(TableType.VIEWTABLE);
        try {
            ttc.like(dataset, false);
            List crCols = dataset.getColumns(ColumnType.CODELISTREF);
            for (Column column : crCols) {
                Table refTable = this.cm.getTable(column.getRelationship().getTargetTableRef().getTableId());
                List levels = (List)((Object)refTable.getMetadataObject(Levels.class));
                int i = 0;
                for (Iterator viewColumnName : ((Level)levels.get(0)).getViewColumnNames()) {
                    Column refColumn = refTable.getColumnByName((String)((Object)viewColumnName));
                    refColumn.setName(String.valueOf(column.getName()) + "_view" + i);
                    refColumn.setLabel(String.valueOf(column.getName()) + "_view" + i);
                    ++i;
                    ttc.addColumn(refColumn);
                }
            }
            Table viewTable = ttc.create();
            this.log.debug("Created view: " + viewTable);
            ArrayList refTables = Lists.newArrayList();
            for (TableRelationship rel : dataset.getRelationships()) {
                refTables.add(this.cm.getTable(rel.getTargetTableRef().getTableId()));
            }
            StringBuilder sqlSelect = new StringBuilder();
            sqlSelect.append("SELECT ");
            for (Column column : dataset.getColumns()) {
                if (column.getColumnType() == ColumnType.ID) continue;
                sqlSelect.append("d." + column.getName() + " ,");
            }
            int i = 0;
            for (Table table : refTables) {
                List levels = (List)((Object)table.getMetadataObject(Levels.class));
                Level level = (Level)levels.get(0);
                for (String levelColumnName : level.getViewColumnNames()) {
                    sqlSelect.append("c" + i + "." + levelColumnName + " ,");
                }
                ++i;
            }
            sqlSelect.deleteCharAt(sqlSelect.length() - 1);
            sqlSelect.append("FROM " + dataset.getName() + " AS d ");
            i = 0;
            for (TableRelationship rel : dataset.getRelationships()) {
                Table refTable = this.cm.getTable(rel.getTargetTableRef().getTableId());
                String refTableAlias = "c" + i;
                sqlSelect.append(" LEFT JOIN " + refTable.getName() + " AS " + refTableAlias + " ON d." + rel.getSourceTableFKRef().getColumnName() + " = " + refTableAlias + ".id");
                ++i;
            }
            StringBuilder orderedColumnNames = new StringBuilder();
            for (Column column : viewTable.getColumns()) {
                orderedColumnNames.append(String.valueOf(column.getName()) + " ,");
            }
            orderedColumnNames.deleteCharAt(orderedColumnNames.length() - 1);
            String sqlInsert = String.format("INSERT INTO %s (%s) ", viewTable.getName(), orderedColumnNames);
            String sql = String.valueOf(sqlInsert) + sqlSelect + ";";
            this.log.debug("Executing view filling SQL statement: " + sql);
            this.execute(sql);
            return viewTable;
        }
        catch (TableCreationException e) {
            this.log.error("Unable to create table", (Throwable)e);
            throw new RuntimeException("An error occurred during table creation. Check server logs.");
        }
        catch (NoSuchTableException e) {
            this.log.error("Unable to find referenced table.", (Throwable)e);
            throw new RuntimeException("An error occurred during table creation. Check server logs.");
        }
        catch (Exception e) {
            this.log.error("Generic exception detected.", (Throwable)e);
            throw new RuntimeException("An error occurred during table creation. Check server logs.");
        }
    }

    private String generateJSON(List<Column> columns, Iterator<String[]> dataIterator) {
        JSONObject json = new JSONObject();
        JSONArray jsonColHeaders = new JSONArray();
        for (Column c : columns) {
            jsonColHeaders.put((Object)c.getName());
        }
        JSONArray jsonRows = new JSONArray();
        while (dataIterator.hasNext()) {
            String[] row = dataIterator.next();
            jsonRows.put((Object)row);
        }
        try {
            json.put("headers", (Object)jsonColHeaders);
            json.put("rows", (Object)jsonRows);
        }
        catch (JSONException e) {
            this.log.error("Unable to produce JSON document.", (Throwable)e);
            throw new RuntimeException("Error occured with serialization of table content. Check server log.");
        }
        return json.toString();
    }

    private Table getTable(long tableId) {
        try {
            return this.cm.getTable(tableId);
        }
        catch (NoSuchTableException e) {
            this.log.error(String.format("A table with id '%s' does not exists.", tableId));
            throw new IllegalArgumentException(String.format("A table with id '%s' does not exists", new Object[]{e}));
        }
    }

    private Connection getConnection() {
        DatabaseEndpoint databaseEndpoint = this.cm.getUnprivilegedDatabaseEndpoint();
        String driver = null;
        for (DatabaseProperty p : databaseEndpoint.getProperties()) {
            if (!p.getKey().equals("driver")) continue;
            driver = p.getValue();
        }
        if (driver == null | driver.isEmpty()) {
            throw new RuntimeException("Unable to locate driver to use for the DB connection.");
        }
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Where is your " + driver + " JDBC Driver? " + "Include in your library path!");
            e.printStackTrace();
            throw new RuntimeException("Unable to find DB driver: " + driver);
        }
        try {
            return DriverManager.getConnection(databaseEndpoint.getConnectionString(), databaseEndpoint.getCredentials().getUsername(), databaseEndpoint.getCredentials().getPassword());
        }
        catch (SQLException e) {
            System.out.println("Connection Failed! Check output console");
            e.printStackTrace();
            throw new RuntimeException("Unable to estabilish a connection to the db using connection string: " + databaseEndpoint.getConnectionString());
        }
    }

    private ResultSet executeQuery(String sql) {
        Connection conn = this.getConnection();
        Statement s = null;
        try {
            s = conn.createStatement();
            ResultSet rs = s.executeQuery(sql);
            conn.close();
            return rs;
        }
        catch (SQLException e) {
            this.log.error("Unable to execute SQL query.", (Throwable)e);
            throw new RuntimeException("Unable to query the DB. Check server logs.");
        }
    }

    private void execute(String sql) {
        Connection conn = this.getConnection();
        Statement s = null;
        try {
            s = conn.createStatement();
            s.execute(sql);
            conn.close();
        }
        catch (SQLException e) {
            this.log.error("Unable to execute SQL query.", (Throwable)e);
            throw new RuntimeException("Unable to query the DB. Check server logs.");
        }
    }
}

