/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.query;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.data.connection.unprivileged.Unprivileged;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TabularQueryUtils {
    private DatabaseConnectionProvider connectionProvider;
    private static Logger log = LoggerFactory.getLogger(TabularQueryUtils.class);

    @Inject
    public TabularQueryUtils(@Unprivileged DatabaseConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    private Connection getConnection() throws SQLException {
        return this.connectionProvider.getConnection();
    }

    public ResultSet executeSQLQuery(String sql) {
        ResultSet rs;
        log.debug("Executing SQL Query: " + sql);
        Connection connection = null;
        Statement statement = null;
        try {
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                rs = statement.executeQuery(sql);
            }
            catch (SQLException e) {
                log.error("Unable to execute SQL query.", (Throwable)e);
                throw new RuntimeException("Unable to query the DB.");
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
        return rs;
    }

    public void executeSQLCommand(String sql) {
        log.debug("Exceuting SQL command: " + sql);
        Connection connection = null;
        Statement statement = null;
        try {
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                statement.execute(sql);
            }
            catch (SQLException e) {
                log.error("Unable to execute SQL query.", (Throwable)e);
                throw new RuntimeException("Unable to query the DB.");
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)connection);
            DbUtils.closeQuietly(statement);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)connection);
        DbUtils.closeQuietly((Statement)statement);
    }
}

