package org.gcube.data.analysis.tabulardata.clientlibrary.proxy;

import static org.gcube.common.clients.exceptions.FaultDSL.again;

import org.gcube.common.calls.jaxws.JAXWSUtils.Empty;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.data.td.commons.webservice.TabularResourceManager;
import org.gcube.data.td.commons.webservice.exception.NoSuchTableException;
import org.gcube.data.td.commons.webservice.exception.NoSuchTabularResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTabularResourceManagerProxy implements TabularResourceManagerProxy {

	private static Logger logger = LoggerFactory.getLogger(DefaultTabularResourceManagerProxy.class);
	
	private final ProxyDelegate<TabularResourceManager> delegate;
		
	public DefaultTabularResourceManagerProxy(ProxyDelegate<TabularResourceManager> config){
		this.delegate = config;
	}

	@Override
	public Long createTabularResource() throws Exception {
		Call<TabularResourceManager, Long> call = new Call<TabularResourceManager, Long>() {

			@Override
			public Long call(TabularResourceManager endpoint) throws Exception {
				return endpoint.createTabularResource();
			}
		};
		return delegate.make(call);
	}

	@Override
	public void remove(final Long tabularResourceId) throws NoSuchTabularResourceException {
		Call<TabularResourceManager, Empty> call = new Call<TabularResourceManager, Empty>() {

			@Override
			public Empty call(TabularResourceManager endpoint) throws Exception {
				endpoint.remove(tabularResourceId);
				return new Empty();
			}
		};
		try {
			delegate.make(call);
		}catch (NoSuchTabularResourceException e) {
			logger.error("no tabular resource found with id {}",tabularResourceId);
			throw e;
		}catch (Exception e) {
			throw again(e).asServiceException();
		}
	}

	@Override
	public Long cloneTabularResource(final Long tabularResourceId, final Long lastTableId)
			throws NoSuchTabularResourceException, NoSuchTableException {
		Call<TabularResourceManager, Long> call = new Call<TabularResourceManager, Long>() {

			@Override
			public Long call(TabularResourceManager endpoint) throws Exception {
				return endpoint.cloneTabularResource(tabularResourceId, lastTableId);
			}
		};
		try {
			return delegate.make(call);
		}catch (NoSuchTabularResourceException e) {
			logger.error("no tabular resource found with id {}",tabularResourceId);
			throw e;
		}catch (NoSuchTableException e) {
			logger.error("table with id {} not found, erorr on history",lastTableId);
			throw e;
		}catch (Exception e) {
			throw again(e).asServiceException();
		}
	}	
	
}
