package org.gcube.data.analysis.tabulardata.clientlibrary.proxy;

import static org.gcube.common.clients.exceptions.FaultDSL.again;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrder;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryPage;
import org.gcube.data.td.commons.webservice.QueryManager;
import org.gcube.data.td.commons.webservice.exception.NoSuchTableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultQueryManagerProxy implements QueryManagerProxy {

	private static Logger logger = LoggerFactory.getLogger(DefaultQueryManagerProxy.class); 
	
	ProxyDelegate<QueryManager> delegate;
	
	public DefaultQueryManagerProxy(ProxyDelegate<QueryManager> config) {
		this.delegate = config;
	}

	@Override
	public Table getTable(final long tableId) throws NoSuchTableException {
		Call<QueryManager, Table> call = new Call<QueryManager, Table>() {

			@Override
			public Table call(QueryManager endpoint) throws Exception {
				return endpoint.getTable(tableId);
			}
		};
		try {
			return delegate.make(call);
		} catch (Exception e) {
			logger.error("erro calling getCapabilities",e);
			throw again(e).asServiceException();
		}
	}

	@Override
	public String queryAsJson(final long tableId, final QueryPage page, final QueryFilter filter,
			final QueryOrder order) throws NoSuchTableException {
		Call<QueryManager, String> call = new Call<QueryManager, String>() {

			@Override
			public String call(QueryManager endpoint) throws Exception {
				return endpoint.queryAsJson(tableId, page, filter, order);
			}
		};
		try {
			return delegate.make(call);
		} catch (Exception e) {
			logger.error("erro calling getCapabilities",e);
			throw again(e).asServiceException();
		}
	}

	@Override
	public int getQueryLenght(final long tableId, final QueryFilter filter)
			throws NoSuchTableException {
		Call<QueryManager, Integer> call = new Call<QueryManager, Integer>() {

			@Override
			public Integer call(QueryManager endpoint) throws Exception {
				return endpoint.getQueryLenght(tableId, filter);
			}
		};
		try {
			return delegate.make(call);
		} catch (Exception e) {
			logger.error("erro calling getCapabilities",e);
			throw again(e).asServiceException();
		}
	}


	
	
}
