package org.gcube.data.analysis.tabulardata.clientlibrary.proxy;

import java.util.List;

import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.OperationNotFoundException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskInfo;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;

public interface OperationManagerProxy {

	List<OperationDefinition> getCapabilities();
		
	OperationDefinition getCapabilities(long operationId) throws OperationNotFoundException;
	
	TaskInfo execute(final long targetTabularResourceId, final OperationExecution invocation)	throws NoSuchTabularResourceException, InvalidInvocationException,
			OperationNotFoundException;

}