/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.n52.wps.commons.WPSConfig;

public final class GenericFileDataConstants {
    public static final String MIME_TYPE_ZIPPED_SHP = "application/x-zipped-shp";
    public static final String MIME_TYPE_SHP = "application/shp";
    public static final String MIME_TYPE_HDF = "application/img";
    public static final String MIME_TYPE_GEOTIFF = "application/geotiff";
    public static final String MIME_TYPE_TIFF = "image/tiff";
    public static final String MIME_TYPE_DBASE = "application/dbase";
    public static final String MIME_TYPE_REMAPFILE = "application/remap";
    public static final String MIME_TYPE_PLAIN_TEXT = "text/plain";
    public static final String MIME_TYPE_TEXT_XML = "text/xml";
    public static final String MIME_TYPE_IMAGE_GEOTIFF = "image/geotiff";
    public static final String MIME_TYPE_X_GEOTIFF = "application/x-geotiff";
    public static final String MIME_TYPE_IMAGE_PNG = "image/png";
    public static final String MIME_TYPE_IMAGE_GIF = "image/gif";
    public static final String MIME_TYPE_IMAGE_JPEG = "image/jpeg";
    public static final String MIME_TYPE_X_ERDAS_HFA = "application/x-erdas-hfa";
    public static final String MIME_TYPE_NETCDF = "application/netcdf";
    public static final String MIME_TYPE_X_NETCDF = "application/x-netcdf";
    public static final String MIME_TYPE_DGN = "application/dgn";
    public static final String MIME_TYPE_KML = "application/vnd.google-earth.kml+xml";
    public static final String MIME_TYPE_HDF4EOS = "application/hdf4-eos";
    public static final String MIME_TYPE_GML200 = "text/xml; subtype=gml/2.0.0";
    public static final String MIME_TYPE_GML211 = "text/xml; subtype=gml/2.1.1";
    public static final String MIME_TYPE_GML212 = "text/xml; subtype=gml/2.1.2";
    public static final String MIME_TYPE_GML2121 = "text/xml; subtype=gml/2.1.2.1";
    public static final String MIME_TYPE_GML300 = "text/xml; subtype=gml/3.0.0";
    public static final String MIME_TYPE_GML301 = "text/xml; subtype=gml/3.0.1";
    public static final String MIME_TYPE_GML310 = "text/xml; subtype=gml/3.1.0";
    public static final String MIME_TYPE_GML311 = "text/xml; subtype=gml/3.1.1";
    public static final String MIME_TYPE_GML321 = "text/xml; subtype=gml/3.2.1";
    private static HashMap<String, String> lut;
    private static final String[] additionalSHPFileItems;

    public static final HashMap<String, String> mimeTypeFileTypeLUT() {
        if (lut == null) {
            lut = new HashMap();
            Properties ioProperties = new Properties();
            try {
                String path = WPSConfig.class.getProtectionDomain().getCodeSource().getLocation().getFile();
                if (path.indexOf("lib/") != -1) {
                    path = path.substring(0, path.indexOf("lib/")).concat("classes/org/n52/wps/io/io.properties");
                } else {
                    File f = new File(GenericFileDataConstants.class.getProtectionDomain().getCodeSource().getLocation().getFile());
                    String projectRoot = f.getParentFile().getParentFile().getParent();
                    path = projectRoot + "/52n-wps-webapp/src/main/webapp/WEB-INF/classes/org/n52/wps/io/io.properties";
                }
                File ioPropertiesFile = new File(path);
                ioProperties.load(new FileInputStream(ioPropertiesFile));
                Enumeration<Object> en = ioProperties.keys();
                while (en.hasMoreElements()) {
                    String type = (String)en.nextElement();
                    System.out.println(type + " " + ioProperties.getProperty(type));
                    lut.put(type, ioProperties.getProperty(type));
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return lut;
    }

    public static final String[] getMimeTypes() {
        return GenericFileDataConstants.mimeTypeFileTypeLUT().keySet().toArray(new String[0]);
    }

    public static final String[] getIncludeFilesByMimeType(String mimeType) {
        String[] returnValue = null;
        if (mimeType != null && mimeType.equalsIgnoreCase(MIME_TYPE_ZIPPED_SHP)) {
            returnValue = additionalSHPFileItems;
        }
        return returnValue;
    }

    static {
        additionalSHPFileItems = new String[]{"shx", "dbf", "prj"};
    }
}

