/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64InputStream;
import org.n52.wps.FormatDocument;
import org.n52.wps.commons.WPSConfig;
import org.n52.wps.io.AbstractIOHandler;
import org.n52.wps.io.IParser;
import org.n52.wps.io.data.IData;

public abstract class AbstractParser
extends AbstractIOHandler
implements IParser {
    protected List<File> finalizeFiles;

    public AbstractParser() {
        this.properties = WPSConfig.getInstance().getPropertiesForParserClass(this.getClass().getName());
        for (FormatDocument.Format format : this.formats = WPSConfig.getInstance().getFormatsForParserClass(this.getClass().getName())) {
            if (format.getMimetype() != null && !format.getMimetype().equals("")) {
                String mimetype = format.getMimetype();
                this.supportedFormats.add(mimetype);
            }
            if (format.getSchema() != null && !format.getSchema().equals("")) {
                String schema = format.getSchema();
                this.supportedSchemas.add(schema);
            }
            if (format.getEncoding() != null && !format.getEncoding().equals("")) {
                String encoding = format.getEncoding();
                this.supportedEncodings.add(encoding);
                continue;
            }
            this.supportedEncodings.add("UTF-8");
        }
        this.finalizeFiles = new ArrayList<File>();
    }

    @Override
    public IData parseBase64(InputStream input, String mimeType, String schema) {
        return this.parse((InputStream)new Base64InputStream(input), mimeType, schema);
    }

    protected void finalize() throws Throwable {
        for (File currentFile : this.finalizeFiles) {
            currentFile.delete();
        }
        super.finalize();
    }
}

