/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.structure.basic;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.graph.structure.DirectedEdge;
import org.geotools.graph.structure.DirectedNode;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.basic.BasicGraphable;

public class BasicDirectedNode
extends BasicGraphable
implements DirectedNode {
    private transient ArrayList m_in = new ArrayList();
    private transient ArrayList m_out = new ArrayList();

    public void add(Edge e) {
        throw new UnsupportedOperationException("add(Edge)");
    }

    public void addIn(DirectedEdge e) {
        this.m_in.add(e);
    }

    public void addOut(DirectedEdge e) {
        this.m_out.add(e);
    }

    public void remove(Edge e) {
        this.m_in.remove(e);
        this.m_out.remove(e);
    }

    public void removeIn(DirectedEdge e) {
        this.m_in.remove(e);
    }

    public void removeOut(DirectedEdge e) {
        this.m_out.remove(e);
    }

    public Edge getEdge(Node other) {
        Edge e = this.getInEdge((DirectedNode)other);
        if (e != null) {
            return e;
        }
        return this.getOutEdge((DirectedNode)other);
    }

    public Edge getInEdge(DirectedNode other) {
        for (int i = 0; i < this.m_in.size(); ++i) {
            DirectedEdge edge = (DirectedEdge)this.m_in.get(i);
            if (!edge.getInNode().equals(other) || !edge.getOutNode().equals(this)) continue;
            return edge;
        }
        return null;
    }

    public Edge getOutEdge(DirectedNode other) {
        for (int i = 0; i < this.m_out.size(); ++i) {
            DirectedEdge edge = (DirectedEdge)this.m_out.get(i);
            if (!edge.getOutNode().equals(other) || !edge.getInNode().equals(this)) continue;
            return edge;
        }
        return null;
    }

    public List getEdges() {
        ArrayList edges = new ArrayList();
        edges.addAll(this.m_in);
        edges.addAll(this.m_out);
        return edges;
    }

    public List getInEdges() {
        return this.m_in;
    }

    public List getOutEdges() {
        return this.m_out;
    }

    public List getEdges(Node other) {
        List edges = this.getInEdges((DirectedNode)other);
        edges.addAll(this.getOutEdges((DirectedNode)other));
        return edges;
    }

    public List getInEdges(DirectedNode other) {
        ArrayList<DirectedEdge> edges = new ArrayList<DirectedEdge>();
        for (int i = 0; i < this.m_in.size(); ++i) {
            DirectedEdge edge = (DirectedEdge)this.m_in.get(i);
            if (!edge.getInNode().equals(other)) continue;
            edges.add(edge);
        }
        return edges;
    }

    public List getOutEdges(DirectedNode other) {
        ArrayList<DirectedEdge> edges = new ArrayList<DirectedEdge>();
        for (int i = 0; i < this.m_out.size(); ++i) {
            DirectedEdge edge = (DirectedEdge)this.m_out.get(i);
            if (!edge.getOutNode().equals(other)) continue;
            edges.add(edge);
        }
        return edges;
    }

    public int getDegree() {
        return this.m_in.size() + this.m_out.size();
    }

    public int getInDegree() {
        return this.m_in.size();
    }

    public int getOutDegree() {
        return this.m_out.size();
    }

    public Iterator getRelated() {
        DirectedEdge e;
        int i;
        ArrayList<DirectedNode> related = new ArrayList<DirectedNode>(this.m_out.size() + this.m_in.size());
        for (i = 0; i < this.m_in.size(); ++i) {
            e = (DirectedEdge)this.m_in.get(i);
            related.add(e.getInNode());
        }
        for (i = 0; i < this.m_out.size(); ++i) {
            e = (DirectedEdge)this.m_out.get(i);
            related.add(e.getOutNode());
        }
        return related.iterator();
    }

    public Iterator getInRelated() {
        ArrayList<DirectedNode> related = new ArrayList<DirectedNode>(this.m_in.size());
        for (int i = 0; i < this.m_in.size(); ++i) {
            DirectedEdge e = (DirectedEdge)this.m_in.get(i);
            related.add(e.getInNode());
        }
        return related.iterator();
    }

    public Iterator getOutRelated() {
        ArrayList<DirectedNode> related = new ArrayList<DirectedNode>(this.m_out.size());
        for (int i = 0; i < this.m_out.size(); ++i) {
            DirectedEdge e = (DirectedEdge)this.m_out.get(i);
            related.add(e.getOutNode());
        }
        return related.iterator();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.m_in = new ArrayList();
        this.m_out = new ArrayList();
    }
}

