/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.prep;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.prep.LineTopology;
import com.vividsolutions.jts.geom.prep.PreparedPolygon;
import com.vividsolutions.jts.noding.SegmentIntersectionDetector;

public class PreparedPolygonLineIntersection {
    protected PreparedPolygon prepPoly;
    LineIntersector li = new RobustLineIntersector();

    public static Geometry intersection(PreparedPolygon prep, Geometry geom) {
        PreparedPolygonLineIntersection op = new PreparedPolygonLineIntersection(prep);
        return op.intersection(geom);
    }

    public PreparedPolygonLineIntersection(PreparedPolygon prepPoly) {
        this.prepPoly = prepPoly;
    }

    public Geometry intersection(Geometry geom) {
        if (!(geom instanceof LineString)) {
            return this.prepPoly.getGeometry().intersection(geom);
        }
        Coordinate[] pts = geom.getCoordinates();
        LineTopology lineTopo = new LineTopology(pts, geom.getFactory());
        this.computeIntersection(lineTopo);
        return lineTopo.getResult();
    }

    private void computeIntersection(LineTopology lineTopo) {
        SegmentIntersectionDetector intDetector = new SegmentIntersectionDetector(this.li);
        intDetector.setFindAllIntersectionTypes(true);
    }
}

