/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.geotools.gml.SubHandler;
import org.geotools.gml.SubHandlerFactory;
import org.geotools.util.logging.Logging;

public class SubHandlerMulti
extends SubHandler {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.gml");
    private static final Collection BASE_GEOMETRY_TYPES = new Vector<String>(Arrays.asList("Point", "LineString", "Polygon"));
    private GeometryFactory geometryFactory = new GeometryFactory();
    private SubHandlerFactory handlerFactory = new SubHandlerFactory();
    private SubHandler currentHandler;
    private List geometries = new Vector();
    private String internalType;
    private boolean internalTypeSet = false;

    public void subGeometry(String message, int type) {
        LOGGER.fine("subGeometry message = " + message + " type = " + type);
        if (!this.internalTypeSet && BASE_GEOMETRY_TYPES.contains(message)) {
            this.internalType = message;
            this.internalTypeSet = true;
            LOGGER.fine("Internal type set to " + message);
        }
        if (message.equals(this.internalType)) {
            if (type == 1) {
                this.currentHandler = this.handlerFactory.create(this.internalType);
            } else if (type == 2) {
                this.geometries.add(this.currentHandler.create(this.geometryFactory));
            } else if (type == 3) {
                this.currentHandler.subGeometry(message, type);
            }
        } else {
            this.currentHandler.subGeometry(message, type);
            LOGGER.fine(this.internalType + " != " + message);
        }
    }

    public void addCoordinate(Coordinate coordinate) {
        this.currentHandler.addCoordinate(coordinate);
    }

    public boolean isComplete(String message) {
        return message.equals("Multi" + this.internalType);
    }

    public Geometry create(GeometryFactory geometryFactory) {
        if (this.internalType.equals("Point")) {
            Point[] pointArray = GeometryFactory.toPointArray((Collection)this.geometries);
            MultiPoint multiPoint = geometryFactory.createMultiPoint(pointArray);
            multiPoint.setUserData((Object)this.getSRS());
            multiPoint.setSRID(this.getSRID());
            LOGGER.fine("created " + multiPoint);
            return multiPoint;
        }
        if (this.internalType.equals("LineString")) {
            LineString[] lineStringArray = GeometryFactory.toLineStringArray((Collection)this.geometries);
            MultiLineString multiLineString = geometryFactory.createMultiLineString(lineStringArray);
            multiLineString.setUserData((Object)this.getSRS());
            multiLineString.setSRID(this.getSRID());
            LOGGER.fine("created " + multiLineString);
            return multiLineString;
        }
        if (this.internalType.equals("Polygon")) {
            Polygon[] polygonArray = GeometryFactory.toPolygonArray((Collection)this.geometries);
            MultiPolygon multiPolygon = geometryFactory.createMultiPolygon(polygonArray);
            multiPolygon.setUserData((Object)this.getSRS());
            multiPolygon.setSRID(this.getSRID());
            LOGGER.fine("created " + multiPolygon);
            return multiPolygon;
        }
        return null;
    }
}

