/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.gml2.GML;
import org.geotools.gml2.bindings.GMLUtil;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class GMLLineStringTypeBinding
extends AbstractComplexBinding {
    CoordinateSequenceFactory csFactory;
    GeometryFactory gFactory;

    public GMLLineStringTypeBinding(CoordinateSequenceFactory csFactory, GeometryFactory gFactory) {
        this.csFactory = csFactory;
        this.gFactory = gFactory;
    }

    public QName getTarget() {
        return GML.LineStringType;
    }

    public int getExecutionMode() {
        return 1;
    }

    public Class getType() {
        return LineString.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List coordinates = node.getChildren("coord");
        if (coordinates.size() == 1) {
            throw new RuntimeException("Linestring must have at least 2 coordinates");
        }
        if (!coordinates.isEmpty()) {
            Node cnode = (Node)coordinates.get(0);
            CoordinateSequence seq = (CoordinateSequence)cnode.getValue();
            int dimension = GMLUtil.getDimension(seq);
            CoordinateSequence lineSeq = this.csFactory.create(coordinates.size(), dimension);
            for (int i = 0; i < coordinates.size(); ++i) {
                cnode = (Node)coordinates.get(i);
                seq = (CoordinateSequence)cnode.getValue();
                for (int j = 0; j < dimension; ++j) {
                    lineSeq.setOrdinate(i, j, seq.getOrdinate(0, j));
                }
            }
            return this.gFactory.createLineString(lineSeq);
        }
        if (node.getChild("coordinates") != null) {
            Node cnode = node.getChild("coordinates");
            CoordinateSequence lineSeq = (CoordinateSequence)cnode.getValue();
            return this.gFactory.createLineString(lineSeq);
        }
        throw new RuntimeException("Could not find coordinates to build linestring");
    }

    public Object getProperty(Object object, QName name) throws Exception {
        LineString lineString = (LineString)object;
        if (GML.coordinates.equals(name)) {
            return lineString.getCoordinateSequence();
        }
        return null;
    }
}

