/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.List;
import org.geotools.data.shapefile.ShapefileAttributeReader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.IndexedDbaseFileReader;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.index.CloseableIterator;
import org.geotools.index.Data;
import org.opengis.feature.type.AttributeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedShapefileAttributeReader
extends ShapefileAttributeReader {
    protected CloseableIterator<Data> goodRecs;
    private Data next;

    public IndexedShapefileAttributeReader(List<AttributeDescriptor> attributes, ShapefileReader shp, IndexedDbaseFileReader dbf, CloseableIterator<Data> goodRecs) {
        this(attributes.toArray(new AttributeDescriptor[0]), shp, dbf, goodRecs);
    }

    public IndexedShapefileAttributeReader(AttributeDescriptor[] atts, ShapefileReader shp, IndexedDbaseFileReader dbf, CloseableIterator<Data> goodRecs) {
        super(atts, shp, (DbaseFileReader)dbf);
        this.goodRecs = goodRecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.goodRecs != null) {
                this.goodRecs.close();
            }
            this.goodRecs = null;
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.goodRecs != null) {
            while (!this.featureAvailable && this.goodRecs.hasNext()) {
                this.next = (Data)this.goodRecs.next();
                Long l = (Long)this.next.getValue(1);
                this.shp.goTo((int)l.longValue());
                this.record = this.shp.nextRecord();
                Envelope envelope = this.record.envelope();
                if (this.targetBBox != null && !this.targetBBox.isNull() && !this.targetBBox.intersects(envelope)) {
                    this.geometry = null;
                    continue;
                }
                if (this.simplificationDistance > 0.0 && envelope.getWidth() < this.simplificationDistance && envelope.getHeight() < this.simplificationDistance) {
                    try {
                        if (this.screenMap != null && this.screenMap.checkAndSet(envelope)) {
                            this.geometry = null;
                            continue;
                        }
                        this.geometry = this.record.getSimplifiedShape(this.screenMap);
                    }
                    catch (Exception e) {
                        this.geometry = this.record.getSimplifiedShape();
                    }
                } else {
                    this.geometry = this.record.shape();
                }
                if (this.dbf != null) {
                    ((IndexedDbaseFileReader)this.dbf).goTo(this.record.number);
                    this.row = this.dbf.readRow();
                } else {
                    this.row = null;
                }
                this.featureAvailable = true;
            }
            return this.featureAvailable;
        }
        return super.hasNext();
    }

    @Override
    public void next() throws IOException {
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException("No more features in reader");
        }
        this.featureAvailable = false;
    }
}

