/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.commons.context;

import org.n52.wps.commons.context.ExecutionContext;

public class ExecutionContextFactory {
    private static final ThreadLocal<ExecutionContext> threadContexts = new ThreadLocal();
    private static ExecutionContext defaultContext;

    public static ExecutionContext getContext() {
        return ExecutionContextFactory.getContext(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutionContext getContext(boolean fallBackToDefault) {
        ExecutionContext executionContext = null;
        ThreadLocal<ExecutionContext> threadLocal = threadContexts;
        synchronized (threadLocal) {
            executionContext = threadContexts.get();
            if (executionContext == null && fallBackToDefault) {
                executionContext = ExecutionContextFactory.getDefault();
            }
        }
        return executionContext;
    }

    public static synchronized ExecutionContext getDefault() {
        if (defaultContext == null) {
            defaultContext = new ExecutionContext();
        }
        return defaultContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerContext(ExecutionContext context) {
        System.out.println("Context registered");
        ThreadLocal<ExecutionContext> threadLocal = threadContexts;
        synchronized (threadLocal) {
            threadContexts.set(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterContext() {
        ThreadLocal<ExecutionContext> threadLocal = threadContexts;
        synchronized (threadLocal) {
            threadContexts.remove();
        }
    }
}

