/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FeatureReaderFeatureIterator
implements SimpleFeatureIterator {
    FeatureReader<SimpleFeatureType, SimpleFeature> reader;

    public FeatureReaderFeatureIterator(FeatureReader<SimpleFeatureType, SimpleFeature> reader) {
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.reader == null) {
                return false;
            }
            if (this.reader.hasNext()) {
                return true;
            }
            this.close();
            return false;
        }
        catch (IOException e) {
            this.close();
            return false;
        }
    }

    @Override
    public SimpleFeature next() {
        if (this.reader == null) {
            throw new NoSuchElementException("Iterator has been closed");
        }
        try {
            return this.reader.next();
        }
        catch (IOException io) {
            this.close();
            NoSuchElementException problem = new NoSuchElementException("Could not obtain the next feature:" + io);
            problem.initCause(io);
            throw problem;
        }
        catch (IllegalAttributeException create) {
            this.close();
            NoSuchElementException problem = new NoSuchElementException("Could not create the next feature:" + (Object)((Object)create));
            problem.initCause((Throwable)((Object)create));
            throw problem;
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("Modification of contents is not supported");
    }

    @Override
    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
    }
}

