/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.referencing.operation.builder.Quadrilateral;
import org.geotools.referencing.operation.builder.TINTriangle;
import org.geotools.referencing.operation.builder.TriangulationException;
import org.opengis.geometry.DirectPosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TriangulationFactory {
    private List<TINTriangle> triangles;

    protected TriangulationFactory(Quadrilateral quad, DirectPosition[] pt) throws TriangulationException {
        ArrayList<DirectPosition> vertices = new ArrayList<DirectPosition>();
        for (int i = 0; i < pt.length; ++i) {
            vertices.add(pt[i]);
        }
        if (!quad.containsAll(vertices)) {
            throw new TriangulationException("Point is outside triangles");
        }
        this.triangles = quad.getTriangles();
        for (DirectPosition vertex : vertices) {
            this.insertPoint(vertex);
        }
    }

    public List<TINTriangle> getTriangulation() {
        return this.triangles;
    }

    protected void recursiveDelaunayTest(List ChangedTriangles) throws TriangulationException {
        int i = ChangedTriangles.size();
        while (i != 0) {
            this.triangles.removeAll(ChangedTriangles);
            ChangedTriangles = this.insertTriangles(ChangedTriangles);
            i = ChangedTriangles.size();
        }
    }

    protected List insertTriangles(List trian) throws TriangulationException {
        ArrayList ChangedTriangles = new ArrayList();
        for (TINTriangle trig : trian) {
            if (trig.getAdjacentTriangles().size() <= 2) {
                this.triangles.add(trig);
                continue;
            }
            ChangedTriangles.addAll(this.delaunayCircleTest(trig));
        }
        return ChangedTriangles;
    }

    private List delaunayCircleTest(TINTriangle triangle) throws TriangulationException {
        ArrayList changedTriangles = new ArrayList();
        Iterator<TINTriangle> j = triangle.getAdjacentTriangles().iterator();
        int ct = changedTriangles.size();
        while (j.hasNext() && changedTriangles.size() == ct) {
            TINTriangle adjacent = j.next();
            ArrayList NewTriangles = new ArrayList();
            if (triangle.getCircumCicle().contains(adjacent.p1) || triangle.getCircumCicle().contains(adjacent.p0) || triangle.getCircumCicle().contains(adjacent.p2)) {
                this.triangles.remove(triangle);
                this.triangles.remove(adjacent);
                NewTriangles.addAll(this.alternativeTriangles(triangle, adjacent));
                this.triangles.addAll(NewTriangles);
                changedTriangles = NewTriangles;
                continue;
            }
            if (this.triangles.contains(triangle)) continue;
            this.triangles.add(triangle);
        }
        return changedTriangles;
    }

    public void insertPoint(DirectPosition newVertex) throws TriangulationException {
        TINTriangle triangleContainingNewVertex = this.triangleContains(newVertex);
        if (triangleContainingNewVertex == null) {
            throw new TriangulationException("Point is outside triangles");
        }
        this.triangles.remove(triangleContainingNewVertex);
        this.recursiveDelaunayTest(triangleContainingNewVertex.subTriangles(newVertex));
    }

    private List alternativeTriangles(TINTriangle ABC, TINTriangle BCD) throws TriangulationException {
        ArrayList<DirectPosition> ABCvertices = new ArrayList<DirectPosition>();
        ArrayList<DirectPosition> BCDvertices = new ArrayList<DirectPosition>();
        ABCvertices.add(ABC.p0);
        ABCvertices.add(ABC.p1);
        ABCvertices.add(ABC.p2);
        BCDvertices.add(BCD.p0);
        BCDvertices.add(BCD.p1);
        BCDvertices.add(BCD.p2);
        ArrayList<DirectPosition> sharedVertices = new ArrayList<DirectPosition>();
        ArrayList<DirectPosition> unsharedVertices = new ArrayList<DirectPosition>();
        for (DirectPosition vertex : ABCvertices) {
            if (!BCDvertices.contains(vertex)) {
                unsharedVertices.add(vertex);
                continue;
            }
            if (BCDvertices.contains(vertex)) {
                sharedVertices.add(vertex);
                BCDvertices.remove(vertex);
                continue;
            }
            throw new TriangulationException("should never reach here");
        }
        unsharedVertices.addAll(BCDvertices);
        if (sharedVertices.size() < 2) {
            throw new TriangulationException("Unable to make alternative triangles");
        }
        ABC.removeAdjacent(BCD);
        BCD.removeAdjacent(ABC);
        TINTriangle trigA = new TINTriangle((DirectPosition)sharedVertices.get(0), (DirectPosition)unsharedVertices.get(0), (DirectPosition)unsharedVertices.get(1));
        TINTriangle trigB = new TINTriangle((DirectPosition)unsharedVertices.get(0), (DirectPosition)unsharedVertices.get(1), (DirectPosition)sharedVertices.get(1));
        trigA.addAdjacentTriangle(trigB);
        trigB.addAdjacentTriangle(trigA);
        trigA.tryToAddAdjacent(BCD.getAdjacentTriangles());
        trigA.tryToAddAdjacent(ABC.getAdjacentTriangles());
        trigB.tryToAddAdjacent(BCD.getAdjacentTriangles());
        trigB.tryToAddAdjacent(ABC.getAdjacentTriangles());
        ArrayList<TINTriangle> list = new ArrayList<TINTriangle>();
        list.add(trigA);
        list.add(trigB);
        for (TINTriangle trig : ABC.getAdjacentTriangles()) {
            trig.removeAdjacent(ABC);
            trig.tryToAddAdjacent(list);
        }
        for (TINTriangle trig : BCD.getAdjacentTriangles()) {
            trig.removeAdjacent(BCD);
            trig.tryToAddAdjacent(list);
        }
        return list;
    }

    private TINTriangle triangleContains(DirectPosition p) {
        for (TINTriangle triangle : this.triangles) {
            if (!triangle.containsOrIsVertex(p)) continue;
            return triangle;
        }
        return null;
    }
}

