/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.log4j.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.DataSourceException;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.n52.wps.io.IOUtils;
import org.n52.wps.io.data.binding.complex.GTRasterDataBinding;
import org.n52.wps.io.datahandler.parser.AbstractParser;

public class GeotiffZippedParser
extends AbstractParser {
    private static Logger LOGGER = Logger.getLogger(GeotiffZippedParser.class);

    public GeotiffZippedParser() {
        this.supportedIDataTypes.add(GTRasterDataBinding.class);
    }

    @Override
    public GTRasterDataBinding parse(InputStream input, String mimeType, String schema) {
        try {
            File zippedFile = IOUtils.writeStreamToFile(input, "zip");
            this.finalizeFiles.add(zippedFile);
            List<File> files = IOUtils.unzipAll(zippedFile);
            this.finalizeFiles.addAll(files);
            for (File file : files) {
                if (!file.getName().endsWith(".tif") && !file.getName().endsWith(".tiff")) continue;
                return this.parseTiff(file);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new RuntimeException("Could not parse zipped geotiff.");
    }

    private GTRasterDataBinding parseTiff(File file) {
        Hints hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
        try {
            GeoTiffReader reader = new GeoTiffReader((Object)file, hints);
            GridCoverage2D coverage = reader.read(null);
            return new GTRasterDataBinding(coverage);
        }
        catch (DataSourceException e) {
            LOGGER.error((Object)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            throw new RuntimeException(e);
        }
    }
}

