/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import java.util.Collection;
import java.util.Comparator;

public class CoordinateArrays {
    private static final Coordinate[] coordArrayType = new Coordinate[0];

    public static Coordinate ptNotInList(Coordinate[] testPts, Coordinate[] pts) {
        for (int i = 0; i < testPts.length; ++i) {
            Coordinate testPt = testPts[i];
            if (CoordinateArrays.indexOf(testPt, pts) >= 0) continue;
            return testPt;
        }
        return null;
    }

    public static int compare(Coordinate[] pts1, Coordinate[] pts2) {
        int i;
        for (i = 0; i < pts1.length && i < pts2.length; ++i) {
            int compare = pts1[i].compareTo(pts2[i]);
            if (compare == 0) continue;
            return compare;
        }
        if (i < pts2.length) {
            return -1;
        }
        if (i < pts1.length) {
            return 1;
        }
        return 0;
    }

    public static int increasingDirection(Coordinate[] pts) {
        for (int i = 0; i < pts.length / 2; ++i) {
            int j = pts.length - 1 - i;
            int comp = pts[i].compareTo(pts[j]);
            if (comp == 0) continue;
            return comp;
        }
        return 1;
    }

    private static boolean isEqualReversed(Coordinate[] pts1, Coordinate[] pts2) {
        for (int i = 0; i < pts1.length; ++i) {
            Coordinate p1 = pts1[i];
            Coordinate p2 = pts2[pts1.length - i - 1];
            if (p1.compareTo(p2) == 0) continue;
            return false;
        }
        return true;
    }

    public static Coordinate[] copyDeep(Coordinate[] coordinates) {
        Coordinate[] copy = new Coordinate[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            copy[i] = new Coordinate(coordinates[i]);
        }
        return copy;
    }

    public static Coordinate[] toCoordinateArray(Collection coordList) {
        return coordList.toArray(coordArrayType);
    }

    public static boolean hasRepeatedPoints(Coordinate[] coord) {
        for (int i = 1; i < coord.length; ++i) {
            if (!coord[i - 1].equals(coord[i])) continue;
            return true;
        }
        return false;
    }

    public static Coordinate[] atLeastNCoordinatesOrNothing(int n, Coordinate[] c) {
        return c.length >= n ? c : new Coordinate[]{};
    }

    public static Coordinate[] removeRepeatedPoints(Coordinate[] coord) {
        if (!CoordinateArrays.hasRepeatedPoints(coord)) {
            return coord;
        }
        CoordinateList coordList = new CoordinateList(coord, false);
        return coordList.toCoordinateArray();
    }

    public static void reverse(Coordinate[] coord) {
        int last = coord.length - 1;
        int mid = last / 2;
        for (int i = 0; i <= mid; ++i) {
            Coordinate tmp = coord[i];
            coord[i] = coord[last - i];
            coord[last - i] = tmp;
        }
    }

    public static boolean equals(Coordinate[] coord1, Coordinate[] coord2) {
        if (coord1 == coord2) {
            return true;
        }
        if (coord1 == null || coord2 == null) {
            return false;
        }
        if (coord1.length != coord2.length) {
            return false;
        }
        for (int i = 0; i < coord1.length; ++i) {
            if (coord1[i].equals(coord2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Coordinate[] coord1, Coordinate[] coord2, Comparator coordinateComparator) {
        if (coord1 == coord2) {
            return true;
        }
        if (coord1 == null || coord2 == null) {
            return false;
        }
        if (coord1.length != coord2.length) {
            return false;
        }
        for (int i = 0; i < coord1.length; ++i) {
            if (coordinateComparator.compare(coord1[i], coord2[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public static Coordinate minCoordinate(Coordinate[] coordinates) {
        Coordinate minCoord = null;
        for (int i = 0; i < coordinates.length; ++i) {
            if (minCoord != null && minCoord.compareTo(coordinates[i]) <= 0) continue;
            minCoord = coordinates[i];
        }
        return minCoord;
    }

    public static void scroll(Coordinate[] coordinates, Coordinate firstCoordinate) {
        int i = CoordinateArrays.indexOf(firstCoordinate, coordinates);
        if (i < 0) {
            return;
        }
        Coordinate[] newCoordinates = new Coordinate[coordinates.length];
        System.arraycopy(coordinates, i, newCoordinates, 0, coordinates.length - i);
        System.arraycopy(coordinates, 0, newCoordinates, coordinates.length - i, i);
        System.arraycopy(newCoordinates, 0, coordinates, 0, coordinates.length);
    }

    public static int indexOf(Coordinate coordinate, Coordinate[] coordinates) {
        for (int i = 0; i < coordinates.length; ++i) {
            if (!coordinate.equals(coordinates[i])) continue;
            return i;
        }
        return -1;
    }

    public static Coordinate[] extract(Coordinate[] pts, int start, int end) {
        int len = end - start + 1;
        Coordinate[] extractPts = new Coordinate[len];
        int iPts = 0;
        for (int i = start; i <= end; ++i) {
            extractPts[iPts++] = pts[i];
        }
        return extractPts;
    }

    public static class BidirectionalComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            if (pts1.length < pts2.length) {
                return -1;
            }
            if (pts1.length > pts2.length) {
                return 1;
            }
            if (pts1.length == 0) {
                return 0;
            }
            int forwardComp = CoordinateArrays.compare(pts1, pts2);
            boolean isEqualRev = CoordinateArrays.isEqualReversed(pts1, pts2);
            if (isEqualRev) {
                return 0;
            }
            return forwardComp;
        }

        public int OLDcompare(Object o1, Object o2) {
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            if (pts1.length < pts2.length) {
                return -1;
            }
            if (pts1.length > pts2.length) {
                return 1;
            }
            if (pts1.length == 0) {
                return 0;
            }
            int dir1 = CoordinateArrays.increasingDirection(pts1);
            int dir2 = CoordinateArrays.increasingDirection(pts2);
            int i1 = dir1 > 0 ? 0 : pts1.length - 1;
            int i2 = dir2 > 0 ? 0 : pts1.length - 1;
            for (int i = 0; i < pts1.length; ++i) {
                int comparePt = pts1[i1].compareTo(pts2[i2]);
                if (comparePt != 0) {
                    return comparePt;
                }
                i1 += dir1;
                i2 += dir2;
            }
            return 0;
        }
    }

    public static class ForwardComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            return CoordinateArrays.compare(pts1, pts2);
        }
    }
}

