/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.resources.Classes;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexTypeImpl
extends AttributeTypeImpl
implements ComplexType {
    private final Collection<PropertyDescriptor> properties;
    private final Map<Name, PropertyDescriptor> propertyMap;

    public ComplexTypeImpl(Name name, Collection<PropertyDescriptor> properties, boolean identified, boolean isAbstract, List<Filter> restrictions, AttributeType superType, InternationalString description) {
        super(name, Collection.class, identified, isAbstract, restrictions, superType, description);
        Map<Name, PropertyDescriptor> localPropertyMap;
        List localProperties;
        if (properties == null) {
            localProperties = Collections.emptyList();
            localPropertyMap = Collections.emptyMap();
        } else {
            localProperties = new ArrayList<PropertyDescriptor>(properties);
            localPropertyMap = new HashMap();
            for (PropertyDescriptor pd : properties) {
                if (pd == null) {
                    throw new NullPointerException("PropertyDescriptor is null - did you request a property that does not exist?");
                }
                localPropertyMap.put(pd.getName(), pd);
            }
        }
        this.properties = Collections.unmodifiableList(localProperties);
        this.propertyMap = Collections.unmodifiableMap(localPropertyMap);
    }

    public Class<Collection<Property>> getBinding() {
        return super.getBinding();
    }

    public Collection<PropertyDescriptor> getDescriptors() {
        return this.properties;
    }

    public PropertyDescriptor getDescriptor(Name name) {
        return this.propertyMap.get(name);
    }

    public PropertyDescriptor getDescriptor(String name) {
        PropertyDescriptor result = this.getDescriptor(new NameImpl(name));
        if (result == null && (result = this.getDescriptor(new NameImpl(this.getName().getNamespaceURI(), name))) == null) {
            for (PropertyDescriptor pd : this.properties) {
                if (!pd.getName().getLocalPart().equals(name)) continue;
                return pd;
            }
        }
        return result;
    }

    public boolean isInline() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ComplexTypeImpl other = (ComplexTypeImpl)o;
        return ((Object)this.properties).equals(other.properties);
    }

    @Override
    public int hashCode() {
        return 59 * super.hashCode() + ((Object)this.properties).hashCode();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(Classes.getShortClassName((Object)this));
        sb.append(" ");
        sb.append(this.getName());
        if (this.isAbstract()) {
            sb.append(" abstract");
        }
        if (this.isIdentified()) {
            sb.append(" identified");
        }
        if (this.superType != null) {
            sb.append(" extends ");
            sb.append(this.superType.getName().getLocalPart());
        }
        if (List.class.isAssignableFrom(this.binding)) {
            sb.append("[");
        } else {
            sb.append("(");
        }
        boolean first = true;
        for (PropertyDescriptor property : this.getDescriptors()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(property.getName().getLocalPart());
            sb.append(":");
            sb.append(property.getType().getName().getLocalPart());
        }
        if (List.class.isAssignableFrom(this.binding)) {
            sb.append("]");
        } else {
            sb.append(")");
        }
        if (this.description != null) {
            sb.append("\n\tdescription=");
            sb.append((CharSequence)this.description);
        }
        if (this.restrictions != null && !this.restrictions.isEmpty()) {
            sb.append("\nrestrictions=");
            first = true;
            for (Filter filter : this.restrictions) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" AND ");
                }
                sb.append(filter);
            }
        }
        return sb.toString();
    }
}

