/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.examples.resampler;

import com.terradue.wps_hadoop.common.HadoopAbstractAlgorithm;
import com.terradue.wps_hadoop.examples.resampler.ResamplerMapper;
import com.terradue.wps_hadoop.examples.resampler.ResamplerReducer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.Reducer;
import org.apache.log4j.Logger;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

public class ResamplerAlgorithm
extends HadoopAbstractAlgorithm<LongWritable, Text> {
    private static Logger LOGGER = Logger.getLogger(ResamplerAlgorithm.class);
    public final UUID SessionUID = UUID.randomUUID();
    protected InetAddress addr;
    private List<String> errors = new ArrayList<String>();

    public List<String> getErrors() {
        return this.errors;
    }

    public Class getInputDataType(String id) {
        return LiteralStringBinding.class;
    }

    public Class getOutputDataType(String id) {
        return LiteralStringBinding.class;
    }

    @Override
    public void prepareToRun(Map<String, List<IData>> inputData) {
        this.startElapsedTime = System.currentTimeMillis();
        if (inputData == null || !inputData.containsKey("wcs_url")) {
            throw new RuntimeException("Error while allocating input parameters 'wcs_url'");
        }
        if (inputData == null || !inputData.containsKey("resolution")) {
            throw new RuntimeException("Error while allocating input parameters 'resolution'");
        }
        LOGGER.info((Object)"Preparation to run done");
    }

    @Override
    protected Class<? extends Mapper<?, ?, LongWritable, Text>> getMapper() {
        return ResamplerMapper.class;
    }

    @Override
    protected Class<? extends Reducer<LongWritable, Text, ?, ?>> getReducer() {
        return ResamplerReducer.class;
    }

    @Override
    protected JobConf getJobConf() {
        return new JobConf(((Object)((Object)this)).getClass());
    }

    @Override
    protected String getJobName() {
        return "resampler";
    }

    @Override
    protected Path[] getInputPaths(Map<String, List<IData>> inputData) {
        String wcs_url = ((LiteralStringBinding)inputData.get("wcs_url").get(0)).getPayload();
        String resolution = ((LiteralStringBinding)inputData.get("resolution").get(0)).getPayload();
        try {
            wcs_url = wcs_url.replaceAll("%25", "&");
            wcs_url = wcs_url.replaceAll("%", "&");
            LOGGER.info((Object)("WCS url = " + wcs_url));
            LOGGER.info((Object)("Session UID = " + this.SessionUID));
            String inputPath = String.valueOf(this.wpsLocation) + "/store/IMarine/local/inputs/" + this.SessionUID;
            LOGGER.debug((Object)("inputPath: " + inputPath));
            File inputDir = new File(inputPath);
            LOGGER.info((Object)("inputDir mkdir " + inputDir.mkdirs()));
            File inputFile = new File(inputDir, "/inputFile");
            BufferedWriter buff = new BufferedWriter(new FileWriter(inputFile));
            LOGGER.info((Object)("Path " + inputFile.getPath()));
            buff.write(String.valueOf(wcs_url) + " " + this.getOutputPath() + " " + resolution);
            buff.close();
            this.hdfs = this.getHdfs();
            this.hdfsPrefix = this.hdfs.getUri().toString();
            LOGGER.info((Object)("hdfsPrefix " + this.hdfsPrefix));
            String workDir = "" + this.hdfs.getWorkingDirectory();
            LOGGER.info((Object)("hdfs working directory  " + workDir));
            Path inputHdfsPath = new Path(String.valueOf(workDir) + "/store/IMarine/hdfs/inputs/" + this.SessionUID);
            LOGGER.info((Object)(" hdfs.copyFromLocalFile  local: " + inputFile.getPath() + "  hdfs location " + inputHdfsPath));
            this.hdfs.copyFromLocalFile(false, true, new Path(inputFile.getPath()), inputHdfsPath);
            Path[] inputPaths = new Path[]{inputHdfsPath};
            return inputPaths;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error getting InputOutputPath " + e.getMessage(), e);
        }
    }

    private FileSystem getHdfs() throws IOException {
        if (this.hadoopConfig.get("fs.defaultFS") != null) {
            this.hadoopConfig.set("fs.defaultFS", "hdfs://node1.hadoop.research-infrastructures.eu:8020/");
        }
        if (this.hadoopConfig.get("fs.AbstractFileSystem.hdfs.impl") == null) {
            this.hadoopConfig.set("fs.AbstractFileSystem.hdfs.impl", "org.apache.hadoop.fs.Hdfs");
        }
        return FileSystem.get((Configuration)this.hadoopConfig);
    }

    @Override
    protected String getOutputPath() {
        try {
            this.hdfs = this.getHdfs();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.hdfs == null) {
            this.logger.info((Object)"hdfs is null");
        } else {
            this.logger.info((Object)("hdfs is " + this.hdfs));
        }
        Path workDir = this.hdfs.getHomeDirectory();
        if (workDir == null) {
            this.logger.info((Object)"working dir is null ");
            workDir = this.hdfs.getHomeDirectory();
        }
        String outputPath = workDir + "/store/IMarine/hdfs/outputs/" + this.SessionUID;
        this.logger.info((Object)("output path setted on hdfs is: " + outputPath));
        return outputPath;
    }

    @Override
    protected Map<String, IData> buildResults() {
        String hostname = null;
        try {
            this.addr = InetAddress.getLocalHost();
            hostname = this.addr.getHostName();
            LOGGER.info((Object)("HostName founded: " + hostname));
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving host name " + e.getCause(), e);
        }
        String result = "http://" + hostname + ":8888/wps/store/IMarine/hdfs/outputs/" + this.SessionUID + "/result.tif";
        HashMap<String, IData> resulthash = new HashMap<String, IData>();
        resulthash.put("result", (IData)new LiteralStringBinding(result));
        try {
            LOGGER.info((Object)" try to copy result from cluster to local ");
            LOGGER.info((Object)("hdfs.copyToLocalFile arguments: " + new Path(this.getOutputPath()) + " " + new Path(String.valueOf(this.wpsLocation) + "/store/IMarine/local/outputs/" + this.SessionUID)));
            this.hdfs.copyToLocalFile(new Path(this.getOutputPath()), new Path(String.valueOf(this.wpsLocation) + "/store/IMarine/hdfs/outputs/" + this.SessionUID));
        }
        catch (IOException e) {
            throw new RuntimeException("Error building results ", e);
        }
        this.endTime = System.currentTimeMillis();
        LOGGER.info((Object)("Elapsed Time " + (this.endTime - this.startElapsedTime) / 1000.0 + " secs"));
        return resulthash;
    }

    @Override
    protected String getJarPath() {
        return "/home/rcirillo/workspace/WPS-hadoop-d4science/target/wps-hadoop-d4s-1.0.0-SNAPSHOT-jar-with-dependencies.jar";
    }
}

