/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.examples.resampler;

import com.terradue.wps_hadoop.common.GeoTiffResampler;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.log4j.Logger;

public class ResamplerMapper
extends MapReduceBase
implements Mapper<LongWritable, Text, LongWritable, Text> {
    private static Logger LOGGER = Logger.getLogger(ResamplerMapper.class);

    public void map(LongWritable key, Text value, OutputCollector<LongWritable, Text> output, Reporter reporter) throws IOException {
        LOGGER.info((Object)"Mapper method init");
        String line = value.toString();
        LOGGER.info((Object)("Line = " + line));
        String[] values = line.split(" ");
        int i = 0;
        LOGGER.debug((Object)("MAPPER # values founded: " + values.length));
        while (i < values.length) {
            LOGGER.debug((Object)("MAPPER values founded: " + values[i] + " index of array is: " + i));
            String wcs_url = values[i];
            LOGGER.info((Object)("wcs url = " + wcs_url));
            String outputPath = values[i + 1];
            LOGGER.info((Object)("Output dir " + outputPath + " index of array is: " + i + 1));
            Double resolution = new Double(values[i + 2]);
            LOGGER.info((Object)("resolution = " + resolution + " index of array is: " + i + 2));
            i += 3;
            LOGGER.info((Object)"call to method resampleToFit ");
            String resTifPath = GeoTiffResampler.resampleToTif(wcs_url, resolution, outputPath).toString();
            LOGGER.info((Object)("end call to method resampleToFit with resutl: " + resTifPath));
            output.collect((Object)key, (Object)new Text(resTifPath));
        }
        output.collect((Object)new LongWritable(1L), (Object)new Text("pippo \u00e8 vivo"));
    }
}

