/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.util.Formatter;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructurePseudoDS;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.JoinParentIndex;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;
import ucar.nc2.ft.point.standard.plug.UnidataPointDatasetHelper;

public class UnidataPointObs
extends TableConfigurerImpl {
    private static Logger log = LoggerFactory.getLogger(UnidataPointObs.class);

    @Override
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        if (wantFeatureType != FeatureType.ANY_POINT && wantFeatureType != FeatureType.STATION && wantFeatureType != FeatureType.POINT) {
            return false;
        }
        FeatureType ft = FeatureDatasetFactoryManager.findFeatureType(ds);
        if (ft == null || ft != FeatureType.STATION && ft != FeatureType.POINT) {
            return false;
        }
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.equalsIgnoreCase("Unidata Observation Dataset v1.0")) continue;
            return true;
        }
        return false;
    }

    @Override
    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) {
        TableConfig obsTable;
        Dimension obsDim = UnidataPointDatasetHelper.findObsDimension(ds);
        if (obsDim == null) {
            errlog.format("Must have an Observation dimension: named by global attribute 'observationDimension', or unlimited dimension", new Object[0]);
            return null;
        }
        boolean hasStruct = Evaluator.hasRecordStructure(ds);
        FeatureType ft = Evaluator.getFeatureType(ds, ":cdm_datatype", null);
        if (ft == null) {
            ft = Evaluator.getFeatureType(ds, ":cdm_data_type", null);
        }
        if (ft == FeatureType.POINT) {
            TableConfig obsTable2 = new TableConfig(Table.Type.Structure, hasStruct ? "record" : obsDim.getName());
            obsTable2.structureType = hasStruct ? TableConfig.StructureType.Structure : TableConfig.StructureType.PsuedoStructure;
            obsTable2.featureType = FeatureType.POINT;
            obsTable2.structName = "record";
            obsTable2.time = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Time, obsDim);
            obsTable2.lat = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Lat, obsDim);
            obsTable2.lon = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Lon, obsDim);
            obsTable2.elev = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Height, obsDim);
            obsTable2.dimName = obsDim.getName();
            return obsTable2;
        }
        if (ft == FeatureType.STATION && wantFeatureType == FeatureType.POINT) {
            TableConfig obsTable3 = new TableConfig(Table.Type.Structure, hasStruct ? "record" : obsDim.getName());
            obsTable3.structureType = hasStruct ? TableConfig.StructureType.Structure : TableConfig.StructureType.PsuedoStructure;
            obsTable3.featureType = FeatureType.POINT;
            obsTable3.dimName = obsDim.getName();
            obsTable3.structName = "record";
            obsTable3.time = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Time, obsDim);
            obsTable3.lat = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Lat, obsDim);
            obsTable3.lon = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Lon, obsDim);
            obsTable3.stnAlt = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Height, obsDim);
            if (obsTable3.lat != null && obsTable3.lon != null) {
                return obsTable3;
            }
            String parentIndexVar = UnidataPointDatasetHelper.findVariableName(ds, "parent_index");
            if (parentIndexVar == null) {
                errlog.format("Must have a parent_index variable", new Object[0]);
                return null;
            }
            Dimension stationDim = UnidataPointDatasetHelper.findDimension(ds, "station");
            if (stationDim == null) {
                errlog.format("Must have a station dimension", new Object[0]);
                return null;
            }
            obsTable3.lat = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Lat, stationDim);
            obsTable3.lon = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Lon, stationDim);
            obsTable3.elev = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Height, stationDim);
            StructurePseudoDS stns = new StructurePseudoDS(ds, null, "stationPsuedoStructure", null, stationDim);
            obsTable3.addJoin(new JoinParentIndex(stns, parentIndexVar));
            return obsTable3;
        }
        if (ft == FeatureType.TRAJECTORY) {
            TableConfig obsTable4 = new TableConfig(Table.Type.Structure, hasStruct ? "record" : obsDim.getName());
            obsTable4.structureType = hasStruct ? TableConfig.StructureType.Structure : TableConfig.StructureType.PsuedoStructure;
            obsTable4.featureType = FeatureType.TRAJECTORY;
            obsTable4.time = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Time, obsDim);
            obsTable4.lat = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Lat, obsDim);
            obsTable4.lon = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Lon, obsDim);
            obsTable4.elev = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Height, obsDim);
            obsTable4.dimName = obsDim.getName();
            Dimension trajDim = UnidataPointDatasetHelper.findDimension(ds, "trajectory");
            if (trajDim != null) {
                log.error("Ignoring trajectory structure " + ds.getLocation());
            }
            return obsTable4;
        }
        Dimension stationDim = UnidataPointDatasetHelper.findDimension(ds, "station");
        if (stationDim == null) {
            errlog.format("Must have a dimension named station, or named by global attribute 'stationDimension'", new Object[0]);
            return null;
        }
        String lastVar = UnidataPointDatasetHelper.findVariableName(ds, "lastChild");
        String prevVar = UnidataPointDatasetHelper.findVariableName(ds, "prevChild");
        String firstVar = UnidataPointDatasetHelper.findVariableName(ds, "firstChild");
        String nextVar = UnidataPointDatasetHelper.findVariableName(ds, "nextChild");
        String numChildrenVar = UnidataPointDatasetHelper.findVariableName(ds, "numChildren");
        boolean isForwardLinkedList = firstVar != null && nextVar != null;
        boolean isBackwardLinkedList = lastVar != null && prevVar != null;
        boolean isContiguousList = !isForwardLinkedList && !isBackwardLinkedList && firstVar != null && numChildrenVar != null;
        boolean isMultiDim = !isForwardLinkedList && !isBackwardLinkedList && !isContiguousList;
        TableConfig stationTable = new TableConfig(Table.Type.Structure, "station");
        stationTable.structureType = TableConfig.StructureType.PsuedoStructure;
        stationTable.featureType = FeatureType.STATION;
        stationTable.dimName = stationDim.getName();
        stationTable.limit = Evaluator.getVariableName(ds, "number_stations", null);
        stationTable.stnId = Evaluator.getVariableName(ds, "station_id", null);
        stationTable.stnDesc = Evaluator.getVariableName(ds, "station_description", null);
        stationTable.stnWmoId = Evaluator.getVariableName(ds, "wmo_id", null);
        stationTable.lat = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Lat);
        stationTable.lon = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Lon);
        stationTable.stnAlt = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Height);
        if (isMultiDim) {
            obsTable = new TableConfig(Table.Type.MultidimInner, "obs");
            obsTable.outerName = stationDim.getName();
            obsTable.innerName = obsDim.getName();
            obsTable.dimName = obsDim.getName();
        } else {
            Table.Type obsType = isForwardLinkedList || isBackwardLinkedList ? Table.Type.LinkedList : Table.Type.Contiguous;
            obsTable = new TableConfig(obsType, hasStruct ? "record" : obsDim.getName());
            obsTable.structureType = hasStruct ? TableConfig.StructureType.Structure : TableConfig.StructureType.PsuedoStructure;
            obsTable.structName = "record";
            if (isForwardLinkedList) {
                obsTable.start = firstVar;
                obsTable.next = nextVar;
            } else if (isBackwardLinkedList) {
                obsTable.start = lastVar;
                obsTable.next = prevVar;
            } else if (isContiguousList) {
                obsTable.start = firstVar;
            }
            obsTable.numRecords = numChildrenVar;
            obsTable.parentIndex = Evaluator.getVariableName(ds, "parent_index", null);
        }
        obsTable.dimName = obsDim.getName();
        obsTable.time = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Time);
        obsTable.timeNominal = Evaluator.getVariableName(ds, "time_nominal", null);
        stationTable.addChild(obsTable);
        return stationTable;
    }
}

