/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.jcatalogue.client.internal.converters;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class AtomDateConverter
implements Converter {
    private static final Pattern PATTERN = Pattern.compile("(\\d{4})(?:-(\\d{2}))?(?:-(\\d{2}))?(?:[Tt](?:(\\d{2}))?(?::(\\d{2}))?(?::(\\d{2}))?(?:\\.(\\d{3}))?)?([Zz])?(?:([+-])(\\d{2}):(\\d{2}))?");

    public Object convert(Class type, Object value) {
        if (value == null) {
            throw new ConversionException("Null values not supported in this version.");
        }
        if (String.class == type) {
            if (value instanceof Date) {
                StringBuilder sb = new StringBuilder();
                Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                c.setTime((Date)value);
                sb.append(c.get(1));
                sb.append('-');
                int f = c.get(2);
                if (f < 9) {
                    sb.append('0');
                }
                sb.append(f + 1);
                sb.append('-');
                f = c.get(5);
                if (f < 10) {
                    sb.append('0');
                }
                sb.append(f);
                sb.append('T');
                f = c.get(11);
                if (f < 10) {
                    sb.append('0');
                }
                sb.append(f);
                sb.append(':');
                f = c.get(12);
                if (f < 10) {
                    sb.append('0');
                }
                sb.append(f);
                sb.append(':');
                f = c.get(13);
                if (f < 10) {
                    sb.append('0');
                }
                sb.append(f);
                sb.append('.');
                f = c.get(14);
                if (f < 100) {
                    sb.append('0');
                }
                if (f < 10) {
                    sb.append('0');
                }
                sb.append(f);
                sb.append('Z');
                return sb.toString();
            }
        } else if (Date.class == type && value instanceof String) {
            Matcher m = PATTERN.matcher((String)value);
            if (m.find()) {
                Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                int hoff = 0;
                int moff = 0;
                int doff = -1;
                if (m.group(9) != null) {
                    doff = m.group(9).equals("-") ? 1 : -1;
                    hoff = doff * (m.group(10) != null ? Integer.parseInt(m.group(10)) : 0);
                    moff = doff * (m.group(11) != null ? Integer.parseInt(m.group(11)) : 0);
                }
                c.set(1, Integer.parseInt(m.group(1)));
                c.set(2, m.group(2) != null ? Integer.parseInt(m.group(2)) - 1 : 0);
                c.set(5, m.group(3) != null ? Integer.parseInt(m.group(3)) : 1);
                c.set(11, m.group(4) != null ? Integer.parseInt(m.group(4)) + hoff : 0);
                c.set(12, m.group(5) != null ? Integer.parseInt(m.group(5)) + moff : 0);
                c.set(13, m.group(6) != null ? Integer.parseInt(m.group(6)) : 0);
                c.set(14, m.group(7) != null ? Integer.parseInt(m.group(7)) : 0);
                return c.getTime();
            }
            throw new IllegalArgumentException("Invalid Date Format");
        }
        throw new ConversionException(String.format("type %s and value %s not supported", type, value));
    }
}

