/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.namenode.JspHelper;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.znerd.xmlenc.XMLOutputter;

abstract class DfsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    static final Log LOG = LogFactory.getLog((String)DfsServlet.class.getCanonicalName());

    DfsServlet() {
    }

    protected void writeXml(Exception except, String path, XMLOutputter doc) throws IOException {
        doc.startTag(RemoteException.class.getSimpleName());
        doc.attribute("path", path);
        if (except instanceof RemoteException) {
            doc.attribute("class", ((RemoteException)except).getClassName());
        } else {
            doc.attribute("class", except.getClass().getName());
        }
        String msg = except.getLocalizedMessage();
        int i = msg.indexOf("\n");
        if (i >= 0) {
            msg = msg.substring(0, i);
        }
        doc.attribute("message", msg.substring(msg.indexOf(":") + 1).trim());
        doc.endTag();
    }

    protected UserGroupInformation getUGI(HttpServletRequest request, Configuration conf) throws IOException {
        return JspHelper.getUGI(request, conf);
    }

    protected ClientProtocol createNameNodeProxy() throws IOException {
        ServletContext context = this.getServletContext();
        NameNode nn = (NameNode)context.getAttribute("name.node");
        if (nn != null) {
            return nn;
        }
        InetSocketAddress nnAddr = (InetSocketAddress)context.getAttribute("name.node.address");
        Configuration conf = new Configuration((Configuration)context.getAttribute("current.conf"));
        return DFSClient.createNamenode(nnAddr, conf);
    }
}

