/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.addressing.handler;

import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.message.addressing.Action;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.To;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.addressing.handler.AbstractAddressingHandler;

public class ClientSideAddressingHandler
extends AbstractAddressingHandler {
    private static final Log LOG = LogFactory.getLog((class$org$apache$ws$addressing$handler$ClientSideAddressingHandler == null ? (class$org$apache$ws$addressing$handler$ClientSideAddressingHandler = ClientSideAddressingHandler.class$("org.apache.ws.addressing.handler.ClientSideAddressingHandler")) : class$org$apache$ws$addressing$handler$ClientSideAddressingHandler).getName());
    private static final String MSG_CONTEXT_PROP__SOAP_ACTION = "javax.xml.rpc.soap.http.soapaction.uri";
    static /* synthetic */ Class class$org$apache$ws$addressing$handler$ClientSideAddressingHandler;

    public boolean handleRequest(MessageContext msgContext) {
        SOAPMessageContext soapMsgContext = (SOAPMessageContext)msgContext;
        try {
            AddressingHeaders headers = (AddressingHeaders)msgContext.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
            if (headers == null) {
                headers = new AddressingHeaders();
            }
            headers.setSetMustUnderstand(this.isMustUnderstandEnabled(msgContext));
            this.addMessageIdHeader(headers);
            this.addToHeader(headers, msgContext);
            this.addActionHeader(headers, msgContext);
            this.addFromHeader(headers, msgContext);
            this.addReplyToHeader(headers, msgContext);
            if (headers.getFaultTo() == null && msgContext.containsProperty("addressing.faultTo.URI")) {
                headers.setFaultTo(new EndpointReference((String)msgContext.getProperty("addressing.faultTo.URI")));
            }
            SOAPMessage msg = soapMsgContext.getMessage();
            headers.toEnvelope(msg.getSOAPPart().getEnvelope(), this.getActor());
            msgContext.setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", headers);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new JAXRPCException("unexpected error in handleRequest(): " + e, e);
        }
        return true;
    }

    public boolean handleResponse(MessageContext msgContext) {
        SOAPMessageContext soapMsgContext = (SOAPMessageContext)msgContext;
        try {
            SOAPMessage msg = soapMsgContext.getMessage();
            if (msg == null) {
                return true;
            }
            AddressingHeaders headers = new AddressingHeaders(msg.getSOAPPart().getEnvelope(), this.getActor(), true, this.isRemoveHeadersEnabled(), false, this.getReferencePropertyQNames());
            msgContext.setProperty("org.apache.axis.message.addressing.RESPONSE.HEADERS", headers);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new JAXRPCException("unexpected error in handleResponse(): " + e, e);
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext) {
        return true;
    }

    protected String getSOAPAction(MessageContext msgContext) {
        String soapAction = (String)msgContext.getProperty(MSG_CONTEXT_PROP__SOAP_ACTION);
        return soapAction != null ? soapAction : "";
    }

    protected void setSOAPAction(MessageContext msgContext, String actionURI) {
        msgContext.setProperty(MSG_CONTEXT_PROP__SOAP_ACTION, actionURI);
    }

    protected String getEndpointURL(MessageContext msgContext) {
        return null;
    }

    private void addReplyToHeader(AddressingHeaders addrHeaders, MessageContext msgContext) throws URI.MalformedURIException {
        if (this.isPropertyTrue(msgContext, "addressing.sendReplyTo") && addrHeaders.getReplyTo() == null) {
            if (msgContext.containsProperty("addressing.replyTo.URI")) {
                addrHeaders.setReplyTo(new EndpointReference((String)msgContext.getProperty("addressing.replyTo.URI")));
            } else {
                addrHeaders.setReplyTo(addrHeaders.getFrom());
            }
        }
    }

    private void addFromHeader(AddressingHeaders addrHeaders, MessageContext msgContext) throws URI.MalformedURIException {
        if (addrHeaders.getFrom() == null) {
            if (msgContext.containsProperty("addressing.from.URI")) {
                addrHeaders.setFrom(new EndpointReference((String)msgContext.getProperty("addressing.from.URI")));
            } else {
                addrHeaders.setFrom(new EndpointReference("http://schemas.xmlsoap.org/ws/2004/03/addressing/role/anonymous"));
            }
        }
    }

    private void addMessageIdHeader(AddressingHeaders addrHeaders) throws URI.MalformedURIException {
        if (addrHeaders.getMessageID() == null) {
            addrHeaders.setMessageID(this.createMessageID());
        }
    }

    private void addToHeader(AddressingHeaders addrHeaders, MessageContext msgContext) throws URI.MalformedURIException {
        if (addrHeaders.getTo() == null) {
            String endpointURL = this.getEndpointURL(msgContext);
            addrHeaders.setTo(endpointURL != null ? new To(endpointURL) : null);
        }
    }

    private void addActionHeader(AddressingHeaders addrHeaders, MessageContext msgContext) throws URI.MalformedURIException {
        String actionURI = this.getSOAPAction(msgContext);
        if (actionURI != null) {
            addrHeaders.setAction(new Action(new URI(actionURI)));
        } else if (addrHeaders.getAction() != null) {
            this.setSOAPAction(msgContext, addrHeaders.getAction().toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

