/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.gass.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URLDecoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.auth.AuthorizationException;
import org.globus.io.gass.server.GassServer;

class GassClientHandler
implements Runnable {
    private static Log logger = LogFactory.getLog((class$org$globus$io$gass$server$GassClientHandler == null ? (class$org$globus$io$gass$server$GassClientHandler = GassClientHandler.class$("org.globus.io.gass.server.GassClientHandler")) : class$org$globus$io$gass$server$GassClientHandler).getName());
    private static final boolean DEBUG_ON = false;
    private static final String CRLF = "\r\n";
    private static final String OKHEADER = "HTTP/1.1 200 OK\r\n";
    private static final String SERVER = "Server: Globus-GASS-HTTP/1.1.0\r\n";
    private static final String CONTENT_LENGTH = "Content-Length:";
    private static final String TRANSFER_ENCODING = "Transfer-Encoding: chunked";
    private static final String JAVA_CLIENT = "User-Agent: Java-Globus-GASS-HTTP/1.1.0";
    private static final String HTTP_CONTINUE = "HTTP/1.1 100 Continue\r\n";
    private static final String CONTENT_BINARY = "Content-Type: application/octet-stream\r\n";
    private static final String CONTENT_HTML = "Content-Type: text/html\r\n";
    private static final String CONTENT_TEXT = "Content-Type: text/plain\r\n";
    private static final String CONNECTION_CLOSE = "Connection: close\r\n";
    private static final String HEADER404 = "HTTP/1.1 404 File Not Found\r\n";
    private static final String MSG404 = "<html><head><title>404 File Not Found</title></head><body>\r\n<h1>404 File Not Found</h1></body></html>\r\n";
    private int BUFFER_SIZE = 4096;
    private GassServer server;
    private Socket socket;
    private int options;
    static /* synthetic */ Class class$org$globus$io$gass$server$GassClientHandler;

    public GassClientHandler(GassServer server, Socket socket) {
        this.server = server;
        this.socket = socket;
        this.options = server.getOptions();
    }

    private void write(OutputStream out, String msg) throws IOException {
        out.write(msg.getBytes());
        out.flush();
    }

    private void writeln(OutputStream out, String msg) throws IOException {
        out.write(msg.getBytes());
        out.write(SERVER.getBytes());
        out.write(CRLF.getBytes());
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block19: {
            InputStream in = null;
            OutputStream out = null;
            try {
                in = this.socket.getInputStream();
                out = this.socket.getOutputStream();
                try {
                    String line = this.readLine(in);
                    if (line.startsWith("GET") && (this.options & 8) != 0) {
                        String path = line.substring(4, line.indexOf(32, 4));
                        while ((line = this.readLine(in)).length() != 0 && line.charAt(0) != '\r' && line.charAt(0) != '\n') {
                        }
                        this.transfer(out, path);
                        break block19;
                    }
                    if (line.startsWith("PUT") && ((this.options & 0x10) != 0 || (this.options & 0x80) != 0)) {
                        String path = line.substring(4, line.indexOf(32, 4));
                        this.transfer(in, path, false, out);
                        this.writeln(out, OKHEADER);
                        break block19;
                    }
                    if (line.startsWith("POST") && ((this.options & 0x10) != 0 || (this.options & 0x20) != 0 || (this.options & 0x40) != 0 || (this.options & 0x80) != 0)) {
                        int index = line.indexOf(63) + 1;
                        String path = line.substring(index, line.indexOf(32, index));
                        this.transfer(in, path, true, out);
                        this.writeln(out, OKHEADER);
                        break block19;
                    }
                    this.writeln(out, "HTTP/1.1 400 Bad Request\r\n");
                }
                catch (FileNotFoundException ex) {
                    logger.debug("FileNotFoundException occured: " + ex.getMessage(), ex);
                    StringBuffer buf = new StringBuffer(HEADER404).append(CONNECTION_CLOSE).append(SERVER).append(CONTENT_HTML).append(CONTENT_LENGTH).append(" ").append(MSG404.length()).append(CRLF).append(CRLF).append(MSG404);
                    out.write(buf.toString().getBytes());
                    out.flush();
                }
                catch (AuthorizationException ex) {
                    logger.debug("Exception occured: Authorization failed");
                    this.writeln(out, "HTTP/1.1 401 Authorization Failed\r\n");
                }
                catch (Exception ex) {
                    logger.debug("Exception occured: " + ex.getMessage(), ex);
                    this.writeln(out, "HTTP/1.1 400 " + ex.getMessage() + CRLF);
                }
            }
            catch (IOException e) {
                logger.error("Error writing response: " + e.getMessage(), e);
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String decodeUrlPath(String path) {
        if (path.length() == 0) {
            return path;
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        try {
            return URLDecoder.decode(path);
        }
        catch (Exception e) {
            return path;
        }
    }

    private void transfer(OutputStream os, String path) throws IOException {
        int read;
        long length;
        path = this.decodeUrlPath(path);
        File f = new File(path);
        FileInputStream file = new FileInputStream(f);
        StringBuffer buf = new StringBuffer(OKHEADER).append(CONNECTION_CLOSE).append(SERVER).append(CONTENT_BINARY).append(CONTENT_LENGTH).append(" ").append(length).append(CRLF).append(CRLF);
        os.write(buf.toString().getBytes());
        os.flush();
        byte[] buffer = new byte[this.BUFFER_SIZE];
        for (length = f.length(); length != 0L && (read = file.read(buffer)) != -1; length -= (long)read) {
            os.write(buffer, 0, read);
        }
        file.close();
        os.flush();
        os.close();
    }

    private OutputStream pickOutputStream(String path, String str, OutputStream def) {
        int strl = str.length();
        int pos = path.indexOf(str);
        if (pos != -1) {
            OutputStream out = this.server.getJobOutputStream(path.substring(pos + strl - 3));
            if (out == null) {
                return def;
            }
            return out;
        }
        return null;
    }

    private void transfer(InputStream is, String path, boolean append, OutputStream outs) throws IOException {
        String line;
        if ((this.options & 0x80) != 0 && path.indexOf("/dev/globus_gass_client_shutdown") != -1) {
            this.server.shutdown();
            return;
        }
        OutputStream out = null;
        long length = 0L;
        boolean chunked = false;
        boolean javaclient = false;
        do {
            if ((line = this.readLine(is)).startsWith(CONTENT_LENGTH)) {
                length = Long.parseLong(line.substring(line.indexOf(58) + 1).trim());
                continue;
            }
            if (line.startsWith(TRANSFER_ENCODING)) {
                chunked = true;
                continue;
            }
            if (!line.startsWith(JAVA_CLIENT)) continue;
            javaclient = true;
        } while (line.length() != 0 && line.charAt(0) != '\r' && line.charAt(0) != '\n');
        out = this.pickOutputStream(path, "/dev/stdout", System.out);
        if (out != null) {
            if ((this.options & 0x20) == 0) {
                throw new IOException("Bad Request");
            }
        } else {
            out = this.pickOutputStream(path, "/dev/stderr", System.err);
            if (out != null) {
                if ((this.options & 0x40) == 0) {
                    throw new IOException("Bad Request");
                }
            } else {
                if ((this.options & 0x10) == 0) {
                    throw new IOException("Bad Request");
                }
                path = this.decodeUrlPath(path);
                out = new FileOutputStream(path, append);
            }
        }
        if (javaclient) {
            this.writeln(outs, HTTP_CONTINUE);
        }
        byte[] buffer = new byte[this.BUFFER_SIZE];
        if (!chunked) {
            int read;
            while (length != 0L && (read = is.read(buffer)) != -1) {
                out.write(buffer, 0, read);
                length -= (long)read;
            }
        } else {
            do {
                int bytes;
                int read;
                line = this.readLine(is);
                for (long chunkLength = length = this.fromHex(line); chunkLength != 0L && (read = is.read(buffer, 0, bytes = chunkLength > (long)buffer.length ? buffer.length : (int)chunkLength)) != -1; chunkLength -= (long)read) {
                    out.write(buffer, 0, read);
                }
                is.read();
                is.read();
            } while (length > 0L);
        }
        out.flush();
        if (out == System.out || out == System.err) {
            return;
        }
        out.close();
    }

    private String readLine(InputStream in) throws IOException {
        int c;
        StringBuffer buf = new StringBuffer();
        for (int length = 0; (c = in.read()) != -1 && c != 10 && length <= 512; ++length) {
            if (c == 13) {
                in.read();
                return buf.toString();
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    private long fromHex(String s) {
        long result = 0L;
        int size = s.length();
        block5: for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            result *= 16L;
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    result += (long)(c - 48);
                    continue block5;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    result += (long)(c - 97 + 10);
                    continue block5;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    result += (long)(c - 65 + 10);
                    continue block5;
                }
            }
        }
        return result;
    }

    private void debug(String msg) {
        System.err.println(msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

