/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.xml.rpc.Stub;
import org.apache.axis.AxisEngine;
import org.apache.axis.client.Service;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.auth.NoAuthorization;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.net.ServerSocketFactory;
import org.globus.util.I18n;
import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.container.ContainerException;
import org.globus.wsrf.container.SecureContainerException;
import org.globus.wsrf.container.ServiceContainerCollection;
import org.globus.wsrf.container.ServiceDispatcher;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.utils.FaultHelper;
import org.globus.wsrf.utils.Resources;
import org.ietf.jgss.GSSCredential;
import org.oasis.wsrf.properties.GetResourceProperty;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.oasis.wsrf.properties.WSResourcePropertiesServiceLocator;
import org.oasis.wsrf.servicegroup.EntryType;

public class ServiceContainer {
    static I18n i18n = I18n.getI18n(Resources.class.getName());
    public static final String HARD_SHUTDOWN = "hardShutdown";
    public static final int DEFAULT_PORT = 8080;
    public static final int DEFAULT_SECURE_PORT = 8443;
    public static final String PORT = "container.port";
    public static final String CLASS = "container.class";
    public static final String MAIN_THREAD = "container.mainThread";
    public static final String THREADS = "container.threads";
    public static final String SERVER_CONFIG = "container.server.config";
    public static final String CONTAINER_DESCRIPTOR = "container.descriptor";
    protected URL url;
    protected ServiceDispatcher dispatcher;
    protected Map properties;
    private int references = 0;
    protected static Hashtable containers = new Hashtable();
    private static Log logger = LogFactory.getLog(ServiceContainer.class.getName());

    public static ServiceContainer createContainer(boolean isMainThread) throws ContainerException {
        Properties props = new Properties();
        props.put(MAIN_THREAD, isMainThread ? Boolean.TRUE : Boolean.FALSE);
        return ServiceContainer.createContainer(props);
    }

    public static ServiceContainer createContainer(boolean isMainThread, int port) throws ContainerException {
        Properties props = new Properties();
        props.put(MAIN_THREAD, isMainThread ? Boolean.TRUE : Boolean.FALSE);
        props.put(PORT, new Integer(port));
        return ServiceContainer.createContainer(props);
    }

    public static synchronized ServiceContainer createContainer(Map properties) throws ContainerException {
        if (properties == null) {
            throw new IllegalArgumentException(i18n.getMessage("containerPropertiesNotSpecified"));
        }
        ServiceContainer container = (ServiceContainer)containers.get(properties);
        if (container == null || !container.increaseReferences()) {
            Class containerClass = null;
            String prop = (String)properties.get(CLASS);
            if (prop == null) {
                containerClass = ServiceContainer.class;
            } else {
                try {
                    containerClass = Class.forName(prop);
                }
                catch (Exception e) {
                    throw new ContainerException(e);
                }
                if (!ServiceContainer.class.isAssignableFrom(containerClass)) {
                    throw new ContainerException(i18n.getMessage("containerClassError", prop));
                }
            }
            try {
                Constructor con = containerClass.getConstructor(Map.class);
                container = (ServiceContainer)con.newInstance(properties);
            }
            catch (InvocationTargetException e) {
                Throwable ex = e.getTargetException();
                if (ex instanceof SecureContainerException) {
                    throw (SecureContainerException)ex;
                }
                if (ex instanceof ContainerException) {
                    throw (ContainerException)ex;
                }
                if (ex instanceof Exception) {
                    throw new ContainerException((Exception)ex);
                }
                throw new ContainerException(e);
            }
            catch (Exception e) {
                throw new ContainerException(e);
            }
        }
        return container;
    }

    protected ServiceContainer() {
    }

    public ServiceContainer(Map properties) throws ContainerException {
        if (properties == null) {
            throw new IllegalArgumentException(i18n.getMessage("containerPropertiesNotSpecified"));
        }
        this.properties = properties;
        int port = 0;
        Integer portProp = (Integer)properties.get(PORT);
        if (portProp != null) {
            port = portProp;
        }
        boolean isMainThread = false;
        Boolean threadProp = (Boolean)properties.get(MAIN_THREAD);
        if (threadProp != null) {
            isMainThread = threadProp;
        }
        int threads = -1;
        Integer threadsProp = (Integer)properties.get(THREADS);
        if (threadsProp != null) {
            threads = threadsProp;
        }
        try {
            this.start(isMainThread, port, threads);
        }
        catch (ContainerException e) {
            try {
                this.close();
            }
            catch (IOException io) {
                // empty catch block
            }
            throw e;
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (IOException io) {
                // empty catch block
            }
            throw new ContainerException(i18n.getMessage("containerInitError"), e);
        }
    }

    protected ServiceDispatcher createServiceDispatcher() throws Exception {
        return new ServiceDispatcher(this.properties);
    }

    public String getProtocol() {
        return "http";
    }

    protected void start(boolean isMainThread, int port, int threads) throws Exception {
        String entropyGenerator;
        this.dispatcher = this.createServiceDispatcher();
        ServerSocketFactory factory = ServerSocketFactory.getDefault();
        ServerSocket socket = factory.createServerSocket(port);
        this.dispatcher.setThreads(threads);
        this.dispatcher.setServerSocket(socket);
        String protocol = this.getProtocol();
        String host = ServiceHost.getHost(this.dispatcher.getAxisEngine());
        int lport = socket.getLocalPort();
        if (!"client".equals(this.properties.get("config.profile"))) {
            ServiceHost.setDefaults(protocol, host, lport);
        }
        this.dispatcher.init();
        this.dispatcher.start(!isMainThread);
        ContainerConfig engConfig = ContainerConfig.getConfig(this.dispatcher.getAxisEngine());
        this.url = new URL(protocol, host, lport, "/" + engConfig.getWSRFLocation());
        logger.debug("Starting server: " + this.url);
        if (logger.isDebugEnabled() && (entropyGenerator = System.getProperty("java.security.egd")) != null) {
            logger.debug("Using " + entropyGenerator + " as " + "entropy generator.");
        }
        ++this.references;
        ServiceContainerCollection.register(this.getURLString(), this);
        containers.put(this.properties, this);
    }

    protected synchronized boolean increaseReferences() {
        if (this.dispatcher == null || this.dispatcher.isStopped()) {
            return false;
        }
        ++this.references;
        return true;
    }

    public synchronized void stop() throws ContainerException {
        if (this.references > 0) {
            --this.references;
        }
        if (this.references == 0) {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new ContainerException(i18n.getMessage("containerStopError"), e);
            }
        }
    }

    protected synchronized void close() throws IOException {
        if (this.url != null) {
            logger.debug("Stopping server: " + this.url);
        }
        if (this.dispatcher != null) {
            this.dispatcher.stop();
        }
        if (this.url != null) {
            ServiceContainerCollection.unregister(this.url.toString());
            containers.remove(this.properties);
            logger.debug("Stopped server: " + this.url);
        }
    }

    public boolean isRunning() {
        return !this.dispatcher.isStopped();
    }

    public int getPort() {
        return this.url.getPort();
    }

    public String getHost() {
        return this.url.getHost();
    }

    public String getURLString() {
        return this.url.toString();
    }

    public URL getURL() {
        return this.url;
    }

    public void waitForInit() throws InterruptedException {
        this.dispatcher.waitForInit();
    }

    public void waitForStop() throws InterruptedException {
        this.dispatcher.waitForStop();
    }

    public AxisEngine getEngine() {
        return this.dispatcher.getAxisEngine();
    }

    public static void main(String[] args) {
        String usageMsg = "Usage: ServiceContainer [options]\nWhere [options] are:\n -help                    Displays this message\n -p <port>                Sets container port number\n -quiet                   Does not show list of services at startup\n -nosec                   Start a non secure (http) container (message\n                          security can still be used)\n -containerDesc <file>    Sets container security descriptor file\n -profile <name>          Specifies different configuration profile\n -debug                   Enables debug mode\n";
        int port = -1;
        boolean secure = true;
        boolean quiet = false;
        boolean debug = false;
        String containerDescFile = null;
        String profile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-p")) {
                if (i + 1 == args.length) {
                    ServiceContainer.exit("Error: -p requires an argument.");
                }
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-nosec")) {
                secure = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                debug = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-help")) {
                ServiceContainer.exit(usageMsg);
                continue;
            }
            if (args[i].equalsIgnoreCase("-containerDesc")) {
                if (i + 1 == args.length) {
                    ServiceContainer.exit("Error: -containerDesc requires an argument.");
                }
                containerDescFile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-quiet")) {
                quiet = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-profile")) {
                if (i + 1 == args.length) {
                    ServiceContainer.exit("Error: -profile requires an argument.");
                }
                profile = args[++i];
                continue;
            }
            ServiceContainer.exit("Error: argument not recognized: " + args[i]);
        }
        if (port == -1) {
            port = secure ? 8443 : 8080;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put(MAIN_THREAD, Boolean.FALSE);
        properties.put(PORT, new Integer(port));
        try {
            if (containerDescFile != null) {
                ContainerSecurityConfig config = ContainerSecurityConfig.getConfig(containerDescFile);
            }
            if (profile != null) {
                properties.put("config.profile", profile);
            }
            ServiceContainer container = secure ? ServiceContainer.startSecurityContainer(properties) : ServiceContainer.createContainer(properties);
            ServiceContainerCollection.ShutdownThread shutdownThread = new ServiceContainerCollection.ShutdownThread();
            Runtime.getRuntime().addShutdownHook(shutdownThread);
            System.setProperty(HARD_SHUTDOWN, "true");
            if (!quiet) {
                ServiceContainer.listServices(container, secure, debug);
            }
            container.waitForInit();
            container.waitForStop();
            if (!quiet) {
                System.out.println(i18n.getMessage("stopServer", container.getURLString()));
            }
        }
        catch (Exception e) {
            if (debug) {
                e.printStackTrace();
            } else {
                System.err.println(i18n.getMessage("startServerError", e.getMessage()));
            }
            System.exit(2);
        }
    }

    public static ServiceContainer startSecurityContainer(Map properties) throws ContainerException {
        properties.put(CLASS, "org.globus.wsrf.container.GSIServiceContainer");
        ServiceContainer container = ServiceContainer.createContainer(properties);
        ContainerConfig config = ContainerConfig.getConfig(container.getEngine());
        config.setOption("httpsPort", String.valueOf(container.getPort()));
        return container;
    }

    private static void exit(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    private static void listServices(ServiceContainer container, boolean secure, boolean debug) {
        WSResourcePropertiesServiceLocator locator = new WSResourcePropertiesServiceLocator();
        String registryService = container.getURLString() + "ContainerRegistryService";
        try {
            GetResourceProperty port = locator.getGetResourcePropertyPort(new URL(registryService));
            if (secure) {
                ((Stub)((Object)port))._setProperty("org.globus.gsi.authorization", NoAuthorization.getInstance());
                Subject subject = ContainerSecurityConfig.getConfig().getSubject();
                GSSCredential cred = JaasGssUtil.getCredential(subject);
                if (cred != null) {
                    ((Stub)((Object)port))._setProperty("org.globus.gsi.credentials", cred);
                }
            }
            GetResourcePropertyResponse response = port.getResourceProperty(WSRFConstants.ENTRY);
            Object[] entries = ObjectDeserializer.toObject(response, EntryType.class);
            Arrays.sort(entries, new Comparator(){

                public int compare(Object o1, Object o2) {
                    EntryType e1 = (EntryType)o1;
                    EntryType e2 = (EntryType)o2;
                    String a1 = e1.getMemberServiceEPR().getAddress().toString();
                    String a2 = e2.getMemberServiceEPR().getAddress().toString();
                    return a1.compareTo(a2);
                }
            });
            System.out.println(i18n.getMessage("startServer", container.getURLString()));
            for (int i = 0; i < entries.length; ++i) {
                EntryType entry = (EntryType)entries[i];
                System.out.println("[" + (i + 1) + "]: " + entry.getMemberServiceEPR().getAddress());
            }
            Service.clearCall();
        }
        catch (Exception e) {
            if (debug) {
                FaultHelper.printStackTrace(e);
            }
            System.err.println(i18n.getMessage("serviceListError", new Object[]{registryService, FaultHelper.getMessage(e)}));
            System.exit(2);
        }
    }
}

