/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.impl;

import java.io.InputStream;
import java.io.OutputStream;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.impl.RemoteResource;
import org.gcube.contentmanagement.blobstorage.service.impl.Resource;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;

public class LocalResource
extends Resource {
    public LocalResource(MyFile file, ServiceEngine engine) {
        super(file, engine);
    }

    public RemoteResource LFile(String path) {
        if (this.getMyFile() != null) {
            this.getMyFile().setPathClient(path);
        } else {
            this.setMyFile(this.extractProperties("", "", path, "local"));
            this.getMyFile().setPathClient(path);
        }
        return new RemoteResource(this.file, this.getEngine());
    }

    public RemoteResource LFile(InputStream is) {
        if (this.getMyFile() != null) {
            this.getMyFile().setInputStream(is);
        } else {
            this.setMyFile(new MyFile());
            this.getMyFile().setInputStream(is);
        }
        return new RemoteResource(this.getMyFile(), this.getEngine());
    }

    public RemoteResource LFile(OutputStream os) {
        if (this.getMyFile() != null) {
            this.getMyFile().setOutputStream(os);
        } else {
            this.setMyFile(new MyFile());
            this.getMyFile().setOutputStream(os);
        }
        return new RemoteResource(this.getMyFile(), this.getEngine());
    }

    public InputStream RFileAStream(String path) {
        this.file = this.extractProperties(this.engine.getContext(), this.engine.owner, path, "remote");
        this.file.setPathServer(path);
        this.file.setOwner(this.engine.owner);
        this.file.setType("input");
        this.setMyFile(this.file);
        this.engine.service.setResource(this.getMyFile());
        String bucketName = null;
        try {
            if (this.file.getInputStream() == null && (this.file.getPathClient() != null || this.file.getPathServer() != null)) {
                bucketName = (String)this.engine.service.startOperation(this.file, this.file.getPathServer(), this.engine.owner, this.engine.server, false, this.engine.getContext(), this.engine.isReplaceOption());
            } else if (this.file.getInputStream() != null || this.file.getOutputStream() != null) {
                bucketName = (String)this.engine.service.startOperation(this.file, this.file.getPathServer(), this.engine.owner, this.engine.server, false, this.engine.getContext());
            } else {
                this.logger.error("parameters incompatible ");
            }
        }
        catch (Exception e) {
            this.logger.error("get()", (Throwable)e);
        }
        InputStream is = this.file.getInputStream();
        this.file.setInputStream(null);
        return is;
    }
}

