/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.reflections.Configuration;
import org.reflections.adapters.JavassistAdapter;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.serializers.Serializer;
import org.reflections.serializers.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationBuilder
implements Configuration {
    private final Set<Scanner> scanners = Sets.newHashSet((Object[])new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner()});
    private Set<URL> urls = Sets.newHashSet();
    private MetadataAdapter metadataAdapter = new JavassistAdapter();
    private Predicate<String> inputsFilter = Predicates.alwaysTrue();
    private Serializer serializer;
    private ExecutorService executorService;
    private ClassLoader[] classLoaders = null;

    @Override
    public Set<Scanner> getScanners() {
        return this.scanners;
    }

    public ConfigurationBuilder setScanners(Scanner ... scanners) {
        this.scanners.clear();
        return this.addScanners(scanners);
    }

    public ConfigurationBuilder addScanners(Scanner ... scanners) {
        this.scanners.addAll(Sets.newHashSet((Object[])scanners));
        return this;
    }

    @Override
    public Set<URL> getUrls() {
        return this.urls;
    }

    public ConfigurationBuilder setUrls(Collection<URL> urls) {
        this.urls = Sets.newHashSet(urls);
        return this;
    }

    public ConfigurationBuilder setUrls(URL ... urls) {
        this.urls = Sets.newHashSet((Object[])urls);
        return this;
    }

    public ConfigurationBuilder setUrls(Collection<URL> ... urlss) {
        this.urls.clear();
        this.addUrls(urlss);
        return this;
    }

    public ConfigurationBuilder addUrls(Collection<URL> urls) {
        this.urls.addAll(urls);
        return this;
    }

    public ConfigurationBuilder addUrls(URL ... urls) {
        this.urls.addAll(Sets.newHashSet((Object[])urls));
        return this;
    }

    public ConfigurationBuilder addUrls(Collection<URL> ... urlss) {
        for (Collection<URL> urls : urlss) {
            this.addUrls(urls);
        }
        return this;
    }

    @Override
    public MetadataAdapter getMetadataAdapter() {
        return this.metadataAdapter;
    }

    public ConfigurationBuilder setMetadataAdapter(MetadataAdapter metadataAdapter) {
        this.metadataAdapter = metadataAdapter;
        return this;
    }

    @Override
    public boolean acceptsInput(String inputFqn) {
        return this.inputsFilter.apply((Object)inputFqn);
    }

    public ConfigurationBuilder filterInputsBy(Predicate<String> inputsFilter) {
        this.inputsFilter = inputsFilter;
        return this;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ConfigurationBuilder setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ConfigurationBuilder useParallelExecutor() {
        return this.useParallelExecutor(Runtime.getRuntime().availableProcessors());
    }

    public ConfigurationBuilder useParallelExecutor(int availableProcessors) {
        this.setExecutorService(Executors.newFixedThreadPool(availableProcessors));
        return this;
    }

    @Override
    public Serializer getSerializer() {
        if (this.serializer == null) {
            this.serializer = new XmlSerializer();
        }
        return this.serializer;
    }

    public ConfigurationBuilder setSerializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    @Override
    public ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }

    public ConfigurationBuilder addClassLoader(ClassLoader classLoader) {
        return this.addClassLoaders(classLoader);
    }

    public ConfigurationBuilder addClassLoaders(ClassLoader ... classLoaders) {
        this.classLoaders = this.classLoaders == null ? classLoaders : (ClassLoader[])ObjectArrays.concat((Object[])this.classLoaders, (Object[])classLoaders, ClassLoader.class);
        return this;
    }

    public ConfigurationBuilder addClassLoaders(Collection<ClassLoader> classLoaders) {
        return this.addClassLoaders(classLoaders.toArray(new ClassLoader[classLoaders.size()]));
    }
}

