/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.examples.intersection;

import com.terradue.wps_hadoop.common.GML;
import com.terradue.wps_hadoop.common.HadoopAbstractAlgorithm;
import com.terradue.wps_hadoop.common.XmlInputFormat;
import com.terradue.wps_hadoop.examples.intersection.IntersectionMapper;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollections;
import org.geotools.feature.FeatureCollection;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class IntersectionHadoopAlgorithm
extends HadoopAbstractAlgorithm<LongWritable, Text> {
    public final UUID SessionUID = UUID.randomUUID();
    protected InetAddress addr;
    private List<String> errors = new ArrayList<String>();
    public final String wpsLocation = String.valueOf(System.getProperty("catalina.base")) + "/webapps/wps/";

    public List<String> getErrors() {
        return this.errors;
    }

    public Class getInputDataType(String id) {
        return LiteralStringBinding.class;
    }

    public Class getOutputDataType(String id) {
        return LiteralStringBinding.class;
    }

    @Override
    public void prepareToRun(Map<String, List<IData>> inputData) {
        if (inputData == null || !inputData.containsKey("Polygon1")) {
            throw new RuntimeException("Error while allocating input parameters");
        }
        if (inputData == null || !inputData.containsKey("Polygon2")) {
            throw new RuntimeException("Error while allocating input parameters");
        }
    }

    @Override
    protected Class<? extends Mapper<?, ?, LongWritable, Text>> getMapper() {
        return IntersectionMapper.class;
    }

    @Override
    protected JobConf getJobConf() {
        JobConf conf = new JobConf(this.hadoopConfig);
        conf.set("xmlinput.start", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        conf.set("xmlinput.end", "</wfs:FeatureCollection>");
        conf.set("sessionuid", this.SessionUID.toString());
        conf.setInputFormat(XmlInputFormat.class);
        return conf;
    }

    @Override
    protected String getJobName() {
        return "intersection";
    }

    @Override
    protected Path[] getInputPaths(Map<String, List<IData>> inputData) {
        String polygon1 = ((LiteralStringBinding)inputData.get("Polygon1").get(0)).getPayload();
        String polygon2 = ((LiteralStringBinding)inputData.get("Polygon2").get(0)).getPayload();
        try {
            this.logger.warn((Object)"getting hdfs");
            this.hdfs = FileSystem.get((Configuration)this.hadoopConfig);
            File inputDir = new File(String.valueOf(this.wpsLocation) + "store/IMarine/local/inputs/" + this.SessionUID);
            this.logger.warn((Object)("creating input dir " + this.wpsLocation + "store/IMarine/local/inputs/" + this.SessionUID));
            FileUtils.forceMkdir((File)inputDir);
            inputDir.mkdirs();
            File tmpDir = new File(String.valueOf(this.wpsLocation) + "store/IMarine/local/tmp/" + this.SessionUID);
            inputDir.mkdirs();
            tmpDir.mkdirs();
            this.logger.warn((Object)"retrieve WPSInputFile");
            this.logger.warn((Object)"Call createHadoopFile");
            this.createHadoopInputFile(polygon1, polygon2, tmpDir);
            this.hdfsPrefix = this.hdfs.getUri().toString();
            Path inputPath = new Path(String.valueOf(this.hdfsPrefix) + this.wpsLocation + "store/IMarine/hdfs/inputs/" + this.SessionUID + "/");
            this.logger.warn((Object)("inputPath " + tmpDir.getPath()));
            this.hdfs.copyFromLocalFile(false, true, new Path(tmpDir.getAbsolutePath()), inputPath);
            Path[] inputPaths = new Path[]{inputPath};
            return inputPaths;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String createHadoopInputFile(String polygon1URL, String polygon2URL, File inputDir) {
        try {
            this.logger.warn((Object)"Called createHadoopInputFile");
            URL urlLine1 = new URL(polygon1URL);
            URL urlLine2 = new URL(polygon2URL.replace(' ', '+'));
            InputStream fis1 = urlLine1.openStream();
            FeatureCollection<SimpleFeatureType, SimpleFeature> polygons = IntersectionHadoopAlgorithm.getFeatures(fis1);
            IntersectionHadoopAlgorithm.closeQuietly(fis1);
            this.logger.warn((Object)("Polygon1 " + urlLine1));
            this.logger.warn((Object)("Polygon2 " + urlLine2));
            InputStream fis2 = urlLine2.openStream();
            FeatureCollection<SimpleFeatureType, SimpleFeature> lineStrings = IntersectionHadoopAlgorithm.getFeatures(fis2);
            IntersectionHadoopAlgorithm.closeQuietly(fis2);
            this.logger.warn((Object)"For every master");
            UUID inputUID = UUID.randomUUID();
            SimpleFeature[] simpleFeatureArray = (SimpleFeature[])polygons.toArray((Object[])new SimpleFeature[polygons.size()]);
            int n = simpleFeatureArray.length;
            int n2 = 0;
            while (n2 < n) {
                SimpleFeature master = simpleFeatureArray[n2];
                SimpleFeature[] simpleFeatureArray2 = (SimpleFeature[])lineStrings.toArray((Object[])new SimpleFeature[lineStrings.size()]);
                int n3 = simpleFeatureArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    SimpleFeature slave = simpleFeatureArray2[n4];
                    this.logger.warn((Object)("For every slave create file " + inputUID));
                    File inputHadoopFile = new File(inputDir, inputUID.toString());
                    this.appendFeaturesToGML(master, slave, inputHadoopFile);
                    inputUID = UUID.randomUUID();
                    inputHadoopFile = new File(inputDir, inputUID.toString());
                    this.appendFeaturesToGML(slave, master, inputHadoopFile);
                    ++n4;
                }
                ++n2;
            }
            return inputDir + "/" + inputUID.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void appendFeaturesToGML(SimpleFeature master, SimpleFeature slave, File inputHadoopFile) {
        try {
            GML encode = new GML(GML.Version.WFS1_1);
            encode.addNamespace(IntersectionHadoopAlgorithm.extractNamePart(slave), IntersectionHadoopAlgorithm.extractNamespacePart(slave));
            encode.addNamespace(IntersectionHadoopAlgorithm.extractNamePart(master), IntersectionHadoopAlgorithm.extractNamespacePart(master));
            this.logger.warn((Object)"encode created");
            FileOutputStream xml = new FileOutputStream(inputHadoopFile);
            this.logger.warn((Object)"xml file created");
            SimpleFeatureCollection fc = DefaultFeatureCollections.newCollection();
            this.logger.warn((Object)"fc created");
            fc.add((Feature)master);
            this.logger.warn((Object)"master added");
            fc.add((Feature)slave);
            this.logger.warn((Object)"slave added");
            encode.encode((OutputStream)xml, fc);
            this.logger.warn((Object)"encoded");
            xml.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String extractNamePart(SimpleFeature feature) {
        String namespaceURI = feature.getType().getName().getNamespaceURI();
        int separatorIndex = namespaceURI.lastIndexOf(47);
        return namespaceURI.substring(++separatorIndex);
    }

    private static String extractNamespacePart(SimpleFeature feature) {
        return feature.getType().getName().getNamespaceURI();
    }

    private static FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures(InputStream is) {
        GML gml = new GML(GML.Version.WFS1_0);
        try {
            SimpleFeatureCollection sfi = gml.decodeFeatureCollection(is);
            return sfi;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getOutputPath() {
        return String.valueOf(this.wpsLocation) + "store/IMarine/hdfs/outputs/" + this.SessionUID + "/";
    }

    @Override
    protected Map buildResults() {
        String result = "";
        String hostname = null;
        try {
            this.addr = InetAddress.getLocalHost();
            hostname = this.addr.getHostName();
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving host name " + e.getCause(), e);
        }
        result = "http://" + hostname + ":8888/wps/outputs/" + this.SessionUID.toString() + "/part-00000";
        try {
            File outDir = new File(String.valueOf(this.wpsLocation) + "outputs");
            outDir.mkdirs();
            this.hdfs.copyToLocalFile(new Path(String.valueOf(this.hdfsPrefix) + this.getOutputPath()), new Path(outDir.getPath()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashMap<String, LiteralStringBinding> resulthash = new HashMap<String, LiteralStringBinding>();
        resulthash.put("result", new LiteralStringBinding(result));
        return resulthash;
    }

    private static final void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

